/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class UnboundedLocalCacheTest {
    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, refreshAfterWrite={CacheSpec.Expire.DISABLED}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    @Test(dataProvider="caches")
    public void noPolicy(Cache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.policy().eviction(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)cache.policy().expireAfterWrite(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)cache.policy().expireAfterAccess(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)cache.policy().refreshAfterWrite(), (Matcher)Matchers.is(Optional.empty()));
    }

    @CacheSpec(implementation={CacheSpec.Implementation.Caffeine}, population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.DISABLED}, weigher={CacheSpec.CacheWeigher.DEFAULT}, expireAfterAccess={CacheSpec.Expire.DISABLED}, expireAfterWrite={CacheSpec.Expire.DISABLED}, refreshAfterWrite={CacheSpec.Expire.DISABLED}, keys={CacheSpec.ReferenceType.STRONG}, values={CacheSpec.ReferenceType.STRONG})
    @Test(dataProvider="caches")
    public void noPolicy_async(AsyncLoadingCache<Integer, Integer> cache, CacheContext context) {
        MatcherAssert.assertThat((Object)cache.synchronous().policy().eviction(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)cache.synchronous().policy().expireAfterWrite(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)cache.synchronous().policy().expireAfterAccess(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)cache.synchronous().policy().refreshAfterWrite(), (Matcher)Matchers.is(Optional.empty()));
    }
}

