/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.buffer;

import com.github.benmanes.caffeine.cache.buffer.FastFlowHeader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

final class FastFlowBuffer<E>
extends FastFlowHeader.ReadAndWriteCounterRef<E> {
    final AtomicReference<E>[] buffer = new AtomicReference[32];

    public FastFlowBuffer() {
        for (int i = 0; i < 32; ++i) {
            this.buffer[i] = new AtomicReference();
        }
    }

    public int offer(E e) {
        long head = this.readCache;
        long tail = this.relaxedWriteCounter();
        long wrap = tail - 32L;
        if (head <= wrap) {
            head = this.readCounter;
            if (head <= wrap) {
                return 1;
            }
            this.lazySetReadCache(head);
        }
        if (this.casWriteCounter(tail, tail + 1L)) {
            int index = (int)(tail & 0x1FL);
            this.buffer[index].lazySet(e);
            return 0;
        }
        return -1;
    }

    public void drainTo(Consumer<E> consumer) {
        int index;
        AtomicReference<E> slot;
        E e;
        long head = this.readCounter;
        long tail = this.relaxedWriteCounter();
        long size = tail - head;
        if (size == 0L) {
            return;
        }
        while ((e = (slot = this.buffer[index = (int)(head & 0x1FL)]).get()) != null) {
            slot.lazySet(null);
            consumer.accept(e);
            if (++head != tail) continue;
        }
        this.lazySetReadCounter(head);
    }

    public int reads() {
        return (int)this.readCounter;
    }

    public int writes() {
        return (int)this.writeCounter;
    }
}

