/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.buffer;

import com.github.benmanes.caffeine.cache.buffer.ManyToOneHeader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

final class ManyToOneBuffer<E>
extends ManyToOneHeader.ReadAndWriteCounterRef<E> {
    final AtomicReference<E>[] buffer = new AtomicReference[32];

    ManyToOneBuffer() {
        for (int i = 0; i < 32; ++i) {
            this.buffer[i] = new AtomicReference();
        }
    }

    public int offer(E e) {
        long head = this.readCounter;
        long tail = this.relaxedWriteCounter();
        long size = tail - head;
        if (size >= 32L) {
            return 1;
        }
        if (this.casWriteCounter(tail, tail + 1L)) {
            int index = (int)(tail & 0x1FL);
            this.buffer[index].lazySet(e);
            return 0;
        }
        return -1;
    }

    public void drainTo(Consumer<E> consumer) {
        int index;
        AtomicReference<E> slot;
        E e;
        long head = this.readCounter;
        long tail = this.relaxedWriteCounter();
        long size = tail - head;
        if (size == 0L) {
            return;
        }
        while ((e = (slot = this.buffer[index = (int)(head & 0x1FL)]).get()) != null) {
            slot.lazySet(null);
            consumer.accept(e);
            if (++head != tail) continue;
        }
        this.lazySetReadCounter(head);
    }

    public int reads() {
        return (int)this.readCounter;
    }

    public int writes() {
        return (int)this.writeCounter;
    }
}

