/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.buffer;

import com.github.benmanes.caffeine.base.UnsafeAccess;
import com.github.benmanes.caffeine.cache.buffer.ManyToOneSpacedHeader;
import java.util.function.Consumer;

final class ManyToOneSpacedBuffer<E>
extends ManyToOneSpacedHeader.ReadAndWriteCounterRef<E> {
    static final int BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    static final int SHIFT = 31 - Integer.numberOfLeadingZeros(UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class));
    static final int SPACED_SIZE = 512;
    static final int SPACED_MASK = 511;
    static final int OFFSET = 16;
    final Object[] buffer = new Object[512];

    ManyToOneSpacedBuffer() {
    }

    public int offer(E e) {
        long head = this.readCounter;
        long tail = this.relaxedWriteCounter();
        long size = tail - head;
        if (size >= 512L) {
            return 1;
        }
        if (this.casWriteCounter(tail, tail + 16L)) {
            long offset = ((tail & 0x1FFL) << SHIFT) + (long)BASE;
            UnsafeAccess.UNSAFE.putOrderedObject(this.buffer, offset, e);
            return 0;
        }
        return -1;
    }

    public void drainTo(Consumer<E> consumer) {
        long offset;
        Object e;
        long head = this.readCounter;
        long tail = this.relaxedWriteCounter();
        long size = tail - head;
        if (size == 0L) {
            return;
        }
        while ((e = UnsafeAccess.UNSAFE.getObjectVolatile(this.buffer, offset = ((head & 0x1FFL) << SHIFT) + (long)BASE)) != null) {
            UnsafeAccess.UNSAFE.putOrderedObject(this.buffer, offset, null);
            consumer.accept(e);
            if ((head += 16L) != tail) continue;
        }
        this.lazySetReadCounter(head);
    }

    public int reads() {
        return (int)this.readCounter / 16;
    }

    public int writes() {
        return (int)this.writeCounter / 16;
    }
}

