/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.buffer;

import com.github.benmanes.caffeine.cache.ReadBuffer;
import java.util.function.Consumer;
import org.jctools.queues.MpscArrayQueue;

final class MpscArrayBuffer<E>
extends ReadBuffer<E> {
    final MpscArrayQueue<E> queue = new MpscArrayQueue(32);
    long drained;

    MpscArrayBuffer() {
    }

    public int offer(E e) {
        return this.queue.relaxedOffer(e) ? 0 : 1;
    }

    public void drainTo(Consumer<E> consumer) {
        Object e = null;
        while ((e = this.queue.poll()) != null) {
            consumer.accept(e);
            ++this.drained;
        }
    }

    public int reads() {
        return (int)this.drained;
    }

    public int writes() {
        return this.drained() + this.queue.size();
    }
}

