/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.buffer;

import com.github.benmanes.caffeine.cache.ReadBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

final class TicketBuffer<E>
extends ReadBuffer<E> {
    final AtomicLong writeCounter = new AtomicLong();
    final AtomicReference<Object>[] buffer = new AtomicReference[32];
    long readCounter;

    TicketBuffer() {
        for (int i = 0; i < 32; ++i) {
            this.buffer[i] = new AtomicReference<Turn>(new Turn(i));
        }
    }

    public int offer(E e) {
        long writeCount = this.writeCounter.get();
        int index = (int)(writeCount & 0x1FL);
        AtomicReference<Object> slot = this.buffer[index];
        Object value = slot.get();
        if (!(value instanceof Turn)) {
            return 1;
        }
        if (((Turn)value).id != writeCount) {
            return -1;
        }
        if (slot.compareAndSet(value, e)) {
            this.writeCounter.lazySet(writeCount + 1L);
            return 0;
        }
        return -1;
    }

    public void drainTo(Consumer<E> consumer) {
        int index;
        AtomicReference<Object> slot;
        for (int i = 0; i < 32 && !((slot = this.buffer[index = (int)(this.readCounter & 0x1FL)]).get() instanceof Turn); ++i) {
            long next = this.readCounter + 32L;
            slot.lazySet(new Turn(next));
            ++this.readCounter;
        }
    }

    public int reads() {
        return (int)this.readCounter;
    }

    public int writes() {
        return this.writeCounter.intValue();
    }

    static final class Turn {
        final long id;

        Turn(long id) {
            this.id = id;
        }

        public String toString() {
            return Long.toString(this.id);
        }
    }
}

