/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.issues;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheProvider;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import java.util.Set;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={CacheValidationListener.class})
@Test(dataProviderClass=CacheProvider.class)
public final class HashClashTest {
    private static final int STEP = 5;
    private static final Long LONG_1 = 1L;
    private static final long ITERS = 200000L;
    private static final boolean debug = false;

    @Test(dataProvider="caches")
    @CacheSpec(population={CacheSpec.Population.EMPTY}, maximumSize={CacheSpec.Maximum.ONE_FIFTY}, stats={CacheSpec.Stats.ENABLED})
    public void testCache(Cache<Long, Long> cache, CacheContext context) {
        for (long j = 0L; j < 300L; ++j) {
            cache.get((Object)1L, Function.identity());
            cache.get((Object)j, Function.identity());
        }
        HashClashTest.printStats(cache);
        HashClashTest.printKeys(cache);
        Long CLASH = 858993459400001L;
        MatcherAssert.assertThat((Object)CLASH.hashCode(), (Matcher)Matchers.is((Object)LONG_1.hashCode()));
        cache.get((Object)CLASH, Function.identity());
        HashClashTest.printKeys(cache);
        for (long j = 0L; j < 300L; ++j) {
            cache.get((Object)1L, Function.identity());
            cache.get((Object)j, Function.identity());
        }
        HashClashTest.printKeys(cache);
        for (long i = 0L; i < 200000L; i += 5L) {
            cache.get((Object)1L, Function.identity());
            for (long j = 0L; j < 5L; ++j) {
                cache.get((Object)(-j), Function.identity());
            }
        }
        HashClashTest.printKeys(cache);
        HashClashTest.printStats(cache);
        MatcherAssert.assertThat((Object)cache.stats().hitRate(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.99))));
    }

    static void printStats(Cache<Long, Long> cache) {
    }

    static void printKeys(Cache<Long, Long> cache) {
    }

    private static /* synthetic */ Set lambda$printKeys$0(Policy.Eviction policy) {
        return policy.hottest(Integer.MAX_VALUE).keySet();
    }
}

