/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.issues;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.testing.Awaits;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"isolated"})
public final class Issue298Test {
    static final long EXPIRE_NS = Duration.ofDays(1L).toNanos();
    AtomicBoolean startedLoad;
    AtomicBoolean doLoad;
    AtomicBoolean startedCreate;
    AtomicBoolean doCreate;
    AtomicBoolean startedRead;
    AtomicBoolean doRead;
    AtomicBoolean endRead;
    AsyncLoadingCache<String, String> cache;
    Policy.VarExpiration<String, String> policy;
    String key;

    @BeforeMethod
    public void before() {
        this.startedCreate = new AtomicBoolean();
        this.startedLoad = new AtomicBoolean();
        this.startedRead = new AtomicBoolean();
        this.doCreate = new AtomicBoolean();
        this.endRead = new AtomicBoolean();
        this.doLoad = new AtomicBoolean();
        this.doRead = new AtomicBoolean();
        this.key = "key";
        this.cache = this.makeAsyncCache();
        this.policy = (Policy.VarExpiration)this.cache.synchronous().policy().expireVariably().get();
    }

    @AfterMethod
    public void after() {
        this.endRead.set(true);
    }

    @Test
    public void readDuringCreate() {
        this.cache.get((Object)this.key);
        Awaits.await().untilTrue(this.startedLoad);
        this.doLoad.set(true);
        Awaits.await().untilTrue(this.startedCreate);
        CompletableFuture<Void> reader = CompletableFuture.runAsync(() -> {
            do {
                this.cache.get((Object)this.key);
            } while (!this.endRead.get());
        });
        this.doCreate.set(true);
        Awaits.await().until(() -> ((Duration)this.policy.getExpiresAfter((Object)this.key).get()).toNanos() <= EXPIRE_NS);
        Awaits.await().untilTrue(this.startedRead);
        this.doRead.set(true);
        this.endRead.set(true);
        reader.join();
        MatcherAssert.assertThat((Object)((Duration)this.policy.getExpiresAfter((Object)this.key).get()).toNanos(), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(EXPIRE_NS))));
    }

    private AsyncLoadingCache<String, String> makeAsyncCache() {
        return Caffeine.newBuilder().expireAfter((Expiry)new Expiry<String, String>(){

            public long expireAfterCreate(@Nonnull String key, @Nonnull String value, long currentTime) {
                Issue298Test.this.startedCreate.set(true);
                Awaits.await().untilTrue(Issue298Test.this.doCreate);
                return EXPIRE_NS;
            }

            public long expireAfterUpdate(@Nonnull String key, @Nonnull String value, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(@Nonnull String key, @Nonnull String value, long currentTime, long currentDuration) {
                Issue298Test.this.startedRead.set(true);
                Awaits.await().untilTrue(Issue298Test.this.doRead);
                return currentDuration;
            }
        }).buildAsync(key -> {
            this.startedLoad.set(true);
            Awaits.await().untilTrue(this.doLoad);
            return key + "'s value";
        });
    }
}

