/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.issues;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.testing.CacheValidationListener;
import com.github.benmanes.caffeine.testing.IsFutureValue;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Test(groups={"isolated"})
@Listeners(value={CacheValidationListener.class})
public final class Issue30Test {
    private static final boolean DEBUG = false;
    private static final String A_KEY = "foo";
    private static final String A_ORIGINAL = "foo0";
    private static final String A_UPDATE_1 = "foo1";
    private static final String A_UPDATE_2 = "foo2";
    private static final String B_KEY = "bar";
    private static final String B_ORIGINAL = "bar0";
    private static final String B_UPDATE_1 = "bar1";
    private static final String B_UPDATE_2 = "bar2";
    private static final int TTL = 100;
    private static final int EPSILON = 10;
    private static final int N_THREADS = 10;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);

    @AfterClass
    public void afterClass() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    @DataProvider(name="params")
    public Object[][] providesCache() {
        ConcurrentHashMap<String, String> source = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, Date> lastLoad = new ConcurrentHashMap<String, Date>();
        AsyncLoadingCache cache = Caffeine.newBuilder().expireAfterWrite(100L, TimeUnit.MILLISECONDS).executor((Executor)this.executor).buildAsync((AsyncCacheLoader)new Loader(source, lastLoad));
        return new Object[][]{{cache, source, lastLoad}};
    }

    @Test(dataProvider="params", invocationCount=100, threadPoolSize=10)
    public void expiration(AsyncLoadingCache<String, String> cache, ConcurrentMap<String, String> source, ConcurrentMap<String, Date> lastLoad) throws Exception {
        this.initialValues(cache, source, lastLoad);
        this.firstUpdate(cache, source);
        this.secondUpdate(cache, source);
    }

    private void initialValues(AsyncLoadingCache<String, String> cache, ConcurrentMap<String, String> source, ConcurrentMap<String, Date> lastLoad) throws InterruptedException, ExecutionException {
        source.put(A_KEY, A_ORIGINAL);
        source.put(B_KEY, B_ORIGINAL);
        lastLoad.clear();
        MatcherAssert.assertThat((String)"should serve initial value", (Object)cache.get((Object)A_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(A_ORIGINAL)));
        MatcherAssert.assertThat((String)"should serve initial value", (Object)cache.get((Object)B_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(B_ORIGINAL)));
    }

    private void firstUpdate(AsyncLoadingCache<String, String> cache, ConcurrentMap<String, String> source) throws InterruptedException, ExecutionException {
        source.put(A_KEY, A_UPDATE_1);
        source.put(B_KEY, B_UPDATE_1);
        MatcherAssert.assertThat((String)"should serve cached initial value", (Object)cache.get((Object)A_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(A_ORIGINAL)));
        MatcherAssert.assertThat((String)"should serve cached initial value", (Object)cache.get((Object)B_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(B_ORIGINAL)));
        Thread.sleep(10L);
        MatcherAssert.assertThat((String)"still serve cached initial value", (Object)cache.get((Object)A_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(A_ORIGINAL)));
        MatcherAssert.assertThat((String)"still serve cached initial value", (Object)cache.get((Object)B_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(B_ORIGINAL)));
        Thread.sleep(110L);
        MatcherAssert.assertThat((String)"now serve first updated value", (Object)cache.get((Object)A_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(A_UPDATE_1)));
        MatcherAssert.assertThat((String)"now serve first updated value", (Object)cache.get((Object)B_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(B_UPDATE_1)));
    }

    private void secondUpdate(AsyncLoadingCache<String, String> cache, ConcurrentMap<String, String> source) throws Exception {
        source.put(A_KEY, A_UPDATE_2);
        source.put(B_KEY, B_UPDATE_2);
        MatcherAssert.assertThat((String)"serve cached first updated value", (Object)cache.get((Object)A_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(A_UPDATE_1)));
        MatcherAssert.assertThat((String)"serve cached first updated value", (Object)cache.get((Object)B_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(B_UPDATE_1)));
        Thread.sleep(10L);
        MatcherAssert.assertThat((String)"serve cached first updated value", (Object)cache.get((Object)A_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(A_UPDATE_1)));
        MatcherAssert.assertThat((String)"serve cached first updated value", (Object)cache.get((Object)A_KEY), (Matcher)Matchers.is(IsFutureValue.futureOf(A_UPDATE_1)));
    }

    static final class Loader
    implements AsyncCacheLoader<String, String> {
        final ConcurrentMap<String, String> source;
        final ConcurrentMap<String, Date> lastLoad;

        Loader(ConcurrentMap<String, String> source, ConcurrentMap<String, Date> lastLoad) {
            this.source = source;
            this.lastLoad = lastLoad;
        }

        public CompletableFuture<String> asyncLoad(String key, Executor executor) {
            this.reportCacheMiss(key);
            return CompletableFuture.completedFuture((String)this.source.get(key));
        }

        private void reportCacheMiss(String key) {
            Date now = new Date();
            Date last = (Date)this.lastLoad.get(key);
            this.lastLoad.put(key, now);
        }
    }
}

