/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.issues;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

@Test(groups={"isolated"})
public final class Solr10141Test {
    static final int blocksInTest = 400;
    static final int maxEntries = 200;
    static final int nThreads = 64;
    static final int nReads = 10000000;
    static final int readsPerThread = 156250;
    static final int readLastBlockOdds = 10;
    static final boolean updateAnyway = true;
    final Random rnd = new Random();

    @Test
    public void eviction() throws Exception {
        final AtomicLong hits = new AtomicLong();
        final AtomicLong inserts = new AtomicLong();
        AtomicLong removals = new AtomicLong();
        RemovalListener listener = (k, v, removalCause) -> {
            MatcherAssert.assertThat((Object)v.key, (Matcher)Matchers.is((Object)k));
            if (!v.live.compareAndSet(true, false)) {
                throw new RuntimeException(String.format("listener called more than once! k=%s, v=%s, removalCause=%s", k, v, removalCause));
            }
            removals.incrementAndGet();
        };
        final Cache cache = Caffeine.newBuilder().removalListener(listener).maximumSize(200L).build();
        final AtomicLong lastBlock = new AtomicLong();
        final AtomicBoolean failed = new AtomicBoolean();
        final AtomicLong maxObservedSize = new AtomicLong();
        ConcurrentTestHarness.timeTasks(64, new Runnable(){

            @Override
            public void run() {
                try {
                    Random r = new Random(Solr10141Test.this.rnd.nextLong());
                    for (int i = 0; i < 156250; ++i) {
                        this.test(r);
                    }
                }
                catch (Throwable e) {
                    failed.set(true);
                    e.printStackTrace();
                }
            }

            void test(Random r) {
                long sz;
                long block = r.nextInt(400);
                if (r.nextInt(10) == 0) {
                    block = lastBlock.get();
                }
                lastBlock.set(block);
                Long k = block;
                Val v = (Val)cache.getIfPresent((Object)k);
                if (v != null) {
                    hits.incrementAndGet();
                    MatcherAssert.assertThat((Object)k, (Matcher)Matchers.is((Object)v.key));
                }
                if (v == null || r.nextBoolean()) {
                    v = new Val();
                    v.key = k;
                    cache.put((Object)k, (Object)v);
                    inserts.incrementAndGet();
                }
                if ((sz = cache.estimatedSize()) > maxObservedSize.get()) {
                    maxObservedSize.set(sz);
                }
            }
        });
        Awaitility.await().until(() -> inserts.get() - removals.get() == cache.estimatedSize());
        System.out.printf("Done!%nentries=%,d inserts=%,d removals=%,d hits=%,d maxEntries=%,d maxObservedSize=%,d%n", cache.estimatedSize(), inserts.get(), removals.get(), hits.get(), 200, maxObservedSize.get());
        MatcherAssert.assertThat((Object)failed.get(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void clear() throws Exception {
        final AtomicLong inserts = new AtomicLong();
        AtomicLong removals = new AtomicLong();
        final AtomicBoolean failed = new AtomicBoolean();
        RemovalListener listener = (k, v, removalCause) -> {
            MatcherAssert.assertThat((Object)v.key, (Matcher)Matchers.is((Object)k));
            if (!v.live.compareAndSet(true, false)) {
                throw new RuntimeException(String.format("listener called more than once! k=%s, v=%s, removalCause=%s", k, v, removalCause));
            }
            removals.incrementAndGet();
        };
        final Cache cache = Caffeine.newBuilder().maximumSize(Integer.MAX_VALUE).removalListener(listener).build();
        ConcurrentTestHarness.timeTasks(64, new Runnable(){

            @Override
            public void run() {
                try {
                    Random r = new Random(Solr10141Test.this.rnd.nextLong());
                    for (int i = 0; i < 156250; ++i) {
                        this.test(r);
                    }
                }
                catch (Throwable e) {
                    failed.set(true);
                    e.printStackTrace();
                }
            }

            void test(Random r) {
                Long k = r.nextInt(400);
                Val v = (Val)cache.getIfPresent((Object)k);
                if (v != null) {
                    MatcherAssert.assertThat((Object)k, (Matcher)Matchers.is((Object)v.key));
                }
                if (v == null || r.nextBoolean()) {
                    v = new Val();
                    v.key = k;
                    cache.put((Object)k, (Object)v);
                    inserts.incrementAndGet();
                }
                if (r.nextInt(10) == 0) {
                    cache.asMap().clear();
                }
            }
        });
        cache.asMap().clear();
        Awaitility.await().until(() -> inserts.get() == removals.get());
        MatcherAssert.assertThat((Object)failed.get(), (Matcher)Matchers.is((Object)false));
    }

    static class Val {
        long key;
        AtomicBoolean live = new AtomicBoolean(true);

        Val() {
        }
    }
}

