/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.stats;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class CacheStatsTest {
    @Test(dataProvider="badArgs", expectedExceptions={IllegalArgumentException.class})
    public void invalid(int hitCount, int missCount, int loadSuccessCount, int loadFailureCount, int totalLoadTime, int evictionCount, int evictionWeight) {
        new CacheStats((long)hitCount, (long)missCount, (long)loadSuccessCount, (long)loadFailureCount, (long)totalLoadTime, (long)evictionCount, (long)evictionWeight);
    }

    @Test
    public void empty() {
        CacheStats stats = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L, 0L);
        CacheStatsTest.checkStats(stats, 0L, 0L, 1.0, 0L, 0.0, 0L, 0L, 0.0, 0L, 0L, 0.0, 0L, 0L);
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)CacheStats.empty())));
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo(null))));
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new Object()))));
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)CacheStats.empty())));
        MatcherAssert.assertThat((Object)stats.hashCode(), (Matcher)Matchers.is((Object)CacheStats.empty().hashCode()));
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.hasToString((String)CacheStats.empty().toString()));
    }

    @Test
    public void populated() {
        CacheStats stats = new CacheStats(11L, 13L, 17L, 19L, 23L, 27L, 54L);
        CacheStatsTest.checkStats(stats, 24L, 11L, 0.4583333333333333, 13L, 0.5416666666666666, 17L, 19L, 0.5277777777777778, 36L, 23L, 0.6388888888888888, 27L, 54L);
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)stats)));
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)CacheStats.empty()))));
        MatcherAssert.assertThat((Object)stats.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)CacheStats.empty().hashCode())));
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.hasToString((Matcher)Matchers.not((Object)CacheStats.empty().toString())));
        CacheStats expected = new CacheStats(11L, 13L, 17L, 19L, 23L, 27L, 54L);
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
        MatcherAssert.assertThat((Object)stats.hashCode(), (Matcher)Matchers.is((Object)expected.hashCode()));
        MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.hasToString((String)expected.toString()));
    }

    @Test
    public void minus() {
        CacheStats one = new CacheStats(11L, 13L, 17L, 19L, 23L, 27L, 54L);
        CacheStats two = new CacheStats(53L, 47L, 43L, 41L, 37L, 31L, 62L);
        CacheStats diff = two.minus(one);
        CacheStatsTest.checkStats(diff, 76L, 42L, 0.5526315789473685, 34L, 0.4473684210526316, 26L, 22L, 0.4583333333333333, 48L, 14L, 0.2916666666666667, 4L, 8L);
        MatcherAssert.assertThat((Object)one.minus(two), (Matcher)Matchers.is((Object)CacheStats.empty()));
    }

    @Test
    public void plus() {
        CacheStats one = new CacheStats(11L, 13L, 15L, 13L, 11L, 9L, 18L);
        CacheStats two = new CacheStats(53L, 47L, 41L, 39L, 37L, 35L, 70L);
        CacheStats sum = two.plus(one);
        CacheStatsTest.checkStats(sum, 124L, 64L, 0.5161290322580645, 60L, 0.4838709677419355, 56L, 52L, 0.48148148148148145, 108L, 48L, 0.4444444444444444, 44L, 88L);
        MatcherAssert.assertThat((Object)sum, (Matcher)Matchers.is((Object)one.plus(two)));
    }

    @Test
    public void overflow() {
        CacheStats max = new CacheStats(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        CacheStatsTest.checkStats(max.plus(max), Long.MAX_VALUE, Long.MAX_VALUE, 1.0, Long.MAX_VALUE, 1.0, Long.MAX_VALUE, Long.MAX_VALUE, 1.0, Long.MAX_VALUE, Long.MAX_VALUE, 1.0, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    private static void checkStats(CacheStats stats, long requestCount, long hitCount, double hitRate, long missCount, double missRate, long loadSuccessCount, long loadFailureCount, double loadFailureRate, long loadCount, long totalLoadTime, double averageLoadPenalty, long evictionCount, long evictionWeight) {
        MatcherAssert.assertThat((Object)stats.requestCount(), (Matcher)Matchers.is((Object)requestCount));
        MatcherAssert.assertThat((Object)stats.hitCount(), (Matcher)Matchers.is((Object)hitCount));
        MatcherAssert.assertThat((Object)stats.hitRate(), (Matcher)Matchers.is((Object)hitRate));
        MatcherAssert.assertThat((Object)stats.missCount(), (Matcher)Matchers.is((Object)missCount));
        MatcherAssert.assertThat((Object)stats.missRate(), (Matcher)Matchers.is((Object)missRate));
        MatcherAssert.assertThat((Object)stats.loadSuccessCount(), (Matcher)Matchers.is((Object)loadSuccessCount));
        MatcherAssert.assertThat((Object)stats.loadFailureCount(), (Matcher)Matchers.is((Object)loadFailureCount));
        MatcherAssert.assertThat((Object)stats.loadFailureRate(), (Matcher)Matchers.is((Object)loadFailureRate));
        MatcherAssert.assertThat((Object)stats.loadCount(), (Matcher)Matchers.is((Object)loadCount));
        MatcherAssert.assertThat((Object)stats.totalLoadTime(), (Matcher)Matchers.is((Object)totalLoadTime));
        MatcherAssert.assertThat((Object)stats.averageLoadPenalty(), (Matcher)Matchers.is((Object)averageLoadPenalty));
        MatcherAssert.assertThat((Object)stats.evictionCount(), (Matcher)Matchers.is((Object)evictionCount));
        MatcherAssert.assertThat((Object)stats.evictionWeight(), (Matcher)Matchers.is((Object)evictionWeight));
    }

    @DataProvider(name="badArgs")
    public Object[][] providesBadArgs() {
        return new Object[][]{{-1, 0, 0, 0, 0, 0, 0}, {0, -1, 0, 0, 0, 0, 0}, {0, 0, -1, 0, 0, 0, 0}, {0, 0, 0, -1, 0, 0, 0}, {0, 0, 0, 0, -1, 0, 0}, {0, 0, 0, 0, 0, -1, 0}, {0, 0, 0, 0, 0, 0, -1}};
    }
}

