/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.stats;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.ConcurrentStatsCounter;
import com.github.benmanes.caffeine.cache.stats.DisabledStatsCounter;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public final class StatsCounterTest {
    @Test
    public void disabled() {
        DisabledStatsCounter counter = DisabledStatsCounter.INSTANCE;
        counter.recordHits(1);
        counter.recordMisses(1);
        counter.recordEviction();
        counter.recordEviction(10);
        counter.recordEviction(1, RemovalCause.SIZE);
        counter.recordLoadSuccess(1L);
        counter.recordLoadFailure(1L);
        MatcherAssert.assertThat((Object)counter.snapshot(), (Matcher)Matchers.is((Object)new CacheStats(0L, 0L, 0L, 0L, 0L, 0L, 0L)));
        MatcherAssert.assertThat((Object)counter.toString(), (Matcher)Matchers.is((Object)new CacheStats(0L, 0L, 0L, 0L, 0L, 0L, 0L).toString()));
        for (DisabledStatsCounter type : DisabledStatsCounter.values()) {
            MatcherAssert.assertThat((Object)DisabledStatsCounter.valueOf((String)type.name()), (Matcher)Matchers.is((Object)counter));
        }
    }

    @Test
    public void enabled() {
        ConcurrentStatsCounter counter = new ConcurrentStatsCounter();
        counter.recordHits(1);
        counter.recordMisses(1);
        counter.recordEviction();
        counter.recordEviction(10);
        counter.recordEviction(1, RemovalCause.SIZE);
        counter.recordLoadSuccess(1L);
        counter.recordLoadFailure(1L);
        CacheStats expected = new CacheStats(1L, 1L, 1L, 1L, 2L, 3L, 11L);
        MatcherAssert.assertThat((Object)counter.snapshot(), (Matcher)Matchers.is((Object)expected));
        MatcherAssert.assertThat((Object)counter.toString(), (Matcher)Matchers.is((Object)expected.toString()));
        MatcherAssert.assertThat((Object)counter.snapshot().toString(), (Matcher)Matchers.is((Object)expected.toString()));
        counter.incrementBy((StatsCounter)counter);
        MatcherAssert.assertThat((Object)counter.snapshot(), (Matcher)Matchers.is((Object)new CacheStats(2L, 2L, 2L, 2L, 4L, 6L, 22L)));
    }

    @Test
    public void concurrent() {
        ConcurrentStatsCounter counter = new ConcurrentStatsCounter();
        ConcurrentTestHarness.timeTasks(5, () -> StatsCounterTest.lambda$concurrent$0((StatsCounter)counter));
        MatcherAssert.assertThat((Object)counter.snapshot(), (Matcher)Matchers.is((Object)new CacheStats(5L, 5L, 5L, 5L, 10L, 10L, 50L)));
    }

    @Test
    public void guarded() {
        StatsCounter counter = StatsCounter.guardedStatsCounter((StatsCounter)new ConcurrentStatsCounter());
        counter.recordHits(1);
        counter.recordMisses(1);
        counter.recordEviction();
        counter.recordEviction(10);
        counter.recordEviction(1, RemovalCause.SIZE);
        counter.recordLoadSuccess(1L);
        counter.recordLoadFailure(1L);
        CacheStats expected = new CacheStats(1L, 1L, 1L, 1L, 2L, 3L, 11L);
        MatcherAssert.assertThat((Object)counter.snapshot(), (Matcher)Matchers.is((Object)expected));
        MatcherAssert.assertThat((Object)counter.toString(), (Matcher)Matchers.is((Object)expected.toString()));
        MatcherAssert.assertThat((Object)counter.snapshot().toString(), (Matcher)Matchers.is((Object)expected.toString()));
    }

    @Test
    public void guarded_exception() {
        StatsCounter statsCounter = (StatsCounter)Mockito.mock(StatsCounter.class);
        Mockito.when((Object)statsCounter.snapshot()).thenThrow(new Throwable[]{new NullPointerException()});
        ((StatsCounter)Mockito.doThrow(NullPointerException.class).when((Object)statsCounter)).recordEviction();
        ((StatsCounter)Mockito.doThrow(NullPointerException.class).when((Object)statsCounter)).recordHits(ArgumentMatchers.anyInt());
        ((StatsCounter)Mockito.doThrow(NullPointerException.class).when((Object)statsCounter)).recordMisses(ArgumentMatchers.anyInt());
        ((StatsCounter)Mockito.doThrow(NullPointerException.class).when((Object)statsCounter)).recordEviction(ArgumentMatchers.anyInt(), (RemovalCause)ArgumentMatchers.any());
        ((StatsCounter)Mockito.doThrow(NullPointerException.class).when((Object)statsCounter)).recordLoadSuccess(ArgumentMatchers.anyLong());
        ((StatsCounter)Mockito.doThrow(NullPointerException.class).when((Object)statsCounter)).recordLoadFailure(ArgumentMatchers.anyLong());
        StatsCounter guarded = StatsCounter.guardedStatsCounter((StatsCounter)statsCounter);
        guarded.recordHits(1);
        guarded.recordMisses(1);
        guarded.recordEviction();
        guarded.recordEviction(10);
        guarded.recordEviction(1, RemovalCause.SIZE);
        guarded.recordLoadSuccess(1L);
        guarded.recordLoadFailure(1L);
        MatcherAssert.assertThat((Object)guarded.snapshot(), (Matcher)Matchers.is((Object)CacheStats.empty()));
        ((StatsCounter)Mockito.verify((Object)statsCounter)).recordHits(1);
        ((StatsCounter)Mockito.verify((Object)statsCounter)).recordMisses(1);
        ((StatsCounter)Mockito.verify((Object)statsCounter)).recordEviction();
        ((StatsCounter)Mockito.verify((Object)statsCounter)).recordEviction(10);
        ((StatsCounter)Mockito.verify((Object)statsCounter)).recordEviction(1, RemovalCause.SIZE);
        ((StatsCounter)Mockito.verify((Object)statsCounter)).recordLoadSuccess(1L);
        ((StatsCounter)Mockito.verify((Object)statsCounter)).recordLoadFailure(1L);
    }

    @Test
    public void overflow_loadSuccess() {
        ConcurrentStatsCounter counter = new ConcurrentStatsCounter();
        counter.recordLoadSuccess(Long.MAX_VALUE);
        counter.recordLoadSuccess(1L);
        CacheStats stats = counter.snapshot();
        MatcherAssert.assertThat((Object)stats.totalLoadTime(), (Matcher)Matchers.is((Object)Long.MAX_VALUE));
    }

    @Test
    public void overflow_loadFailure() {
        ConcurrentStatsCounter counter = new ConcurrentStatsCounter();
        counter.recordLoadFailure(Long.MAX_VALUE);
        counter.recordLoadFailure(1L);
        CacheStats stats = counter.snapshot();
        MatcherAssert.assertThat((Object)stats.totalLoadTime(), (Matcher)Matchers.is((Object)Long.MAX_VALUE));
    }

    private static /* synthetic */ void lambda$concurrent$0(StatsCounter counter) {
        counter.recordHits(1);
        counter.recordMisses(1);
        counter.recordEviction();
        counter.recordEviction(10);
        counter.recordLoadSuccess(1L);
        counter.recordLoadFailure(1L);
    }
}

