/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.GuavaCacheFromContext;
import com.github.benmanes.caffeine.cache.testing.RejectingCacheWriter;
import com.github.benmanes.caffeine.cache.testing.RemovalListeners;
import com.github.benmanes.caffeine.cache.testing.RemovalNotification;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.FakeTicker;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public final class CacheContext {
    final RemovalListener<Integer, Integer> removalListener;
    final CacheWriter<Integer, Integer> cacheWriter;
    final CacheSpec.InitialCapacity initialCapacity;
    final Expiry<Integer, Integer> expiry;
    final Map<Integer, Integer> original;
    final CacheSpec.Implementation implementation;
    final CacheSpec.CacheScheduler cacheScheduler;
    final CacheSpec.Listener removalListenerType;
    final CacheSpec.CacheExecutor cacheExecutor;
    final CacheSpec.ReferenceType valueStrength;
    final CacheSpec.ReferenceType keyStrength;
    final CacheSpec.CacheExpiry expiryType;
    final CacheSpec.Population population;
    final CacheSpec.CacheWeigher weigher;
    final CacheSpec.Maximum maximumSize;
    final Scheduler scheduler;
    final CacheSpec.Expire afterAccess;
    final CacheSpec.Expire afterWrite;
    final CacheSpec.Expire expiryTime;
    final Executor executor;
    final FakeTicker ticker;
    final CacheSpec.Compute compute;
    final CacheSpec.Advance advance;
    final CacheSpec.Expire refresh;
    final CacheSpec.Loader loader;
    final CacheSpec.Writer writer;
    final CacheSpec.Stats stats;
    final boolean isAsyncLoading;
    Cache<?, ?> cache;
    AsyncCache<?, ?> asyncCache;
    Caffeine<Object, Object> caffeine;
    CacheBuilder<Object, Object> guava;
    @Nullable Integer firstKey;
    @Nullable Integer middleKey;
    @Nullable Integer lastKey;
    long initialSize;
    Integer absentKey;
    Integer absentValue;
    Map<Integer, Integer> absent;

    public CacheContext(CacheSpec.InitialCapacity initialCapacity, CacheSpec.Stats stats, CacheSpec.CacheWeigher weigher, CacheSpec.Maximum maximumSize, CacheSpec.CacheExpiry expiryType, CacheSpec.Expire afterAccess, CacheSpec.Expire afterWrite, CacheSpec.Expire refresh, CacheSpec.Advance advance, CacheSpec.ReferenceType keyStrength, CacheSpec.ReferenceType valueStrength, CacheSpec.CacheExecutor cacheExecutor, CacheSpec.CacheScheduler cacheScheduler, CacheSpec.Listener removalListenerType, CacheSpec.Population population, boolean isLoading, boolean isAsyncLoading, CacheSpec.Compute compute, CacheSpec.Loader loader, CacheSpec.Writer writer, CacheSpec.Implementation implementation, CacheSpec cacheSpec) {
        this.initialCapacity = Objects.requireNonNull(initialCapacity);
        this.stats = Objects.requireNonNull(stats);
        this.weigher = Objects.requireNonNull(weigher);
        this.maximumSize = Objects.requireNonNull(maximumSize);
        this.afterAccess = Objects.requireNonNull(afterAccess);
        this.afterWrite = Objects.requireNonNull(afterWrite);
        this.refresh = Objects.requireNonNull(refresh);
        this.advance = Objects.requireNonNull(advance);
        this.keyStrength = Objects.requireNonNull(keyStrength);
        this.valueStrength = Objects.requireNonNull(valueStrength);
        this.cacheExecutor = Objects.requireNonNull(cacheExecutor);
        this.executor = cacheExecutor.create();
        this.cacheScheduler = Objects.requireNonNull(cacheScheduler);
        this.scheduler = cacheScheduler.create();
        this.removalListenerType = removalListenerType;
        this.removalListener = removalListenerType.create();
        this.population = Objects.requireNonNull(population);
        this.loader = isLoading ? Objects.requireNonNull(loader) : null;
        this.isAsyncLoading = isAsyncLoading;
        this.writer = Objects.requireNonNull(writer);
        this.cacheWriter = writer.create();
        this.ticker = new SerializableFakeTicker();
        this.implementation = Objects.requireNonNull(implementation);
        this.original = new LinkedHashMap<Integer, Integer>();
        this.initialSize = -1L;
        this.compute = compute;
        this.expiryType = expiryType;
        this.expiryTime = cacheSpec.expiryTime();
        this.expiry = expiryType.createExpiry(this.expiryTime);
    }

    public CacheSpec.InitialCapacity initialCapacity() {
        return this.initialCapacity;
    }

    public boolean isAsync() {
        return this.compute == CacheSpec.Compute.ASYNC;
    }

    public CacheSpec.Population population() {
        return this.population;
    }

    public Integer firstKey() {
        MatcherAssert.assertThat((String)"Invalid usage of context", (Object)this.firstKey, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        return this.firstKey;
    }

    public Integer middleKey() {
        MatcherAssert.assertThat((String)"Invalid usage of context", (Object)this.middleKey, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        return this.middleKey;
    }

    public Integer lastKey() {
        MatcherAssert.assertThat((String)"Invalid usage of context", (Object)this.lastKey, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        return this.lastKey;
    }

    public Set<Integer> firstMiddleLastKeys() {
        return ImmutableSet.of((Object)this.firstKey(), (Object)this.middleKey(), (Object)this.lastKey());
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public void clear() {
        CacheSpec.interner.get().clear();
        this.initialSize();
        this.original.clear();
        this.absent = null;
        this.absentKey = null;
        this.absentValue = null;
        this.firstKey = null;
        this.middleKey = null;
        this.lastKey = null;
    }

    public Integer absentKey() {
        return this.absentKey == null ? (this.absentKey = this.nextAbsentKey()) : this.absentKey;
    }

    public Integer absentValue() {
        return this.absentValue == null ? (this.absentValue = Integer.valueOf(-this.absentKey().intValue())) : this.absentValue;
    }

    public Map<Integer, Integer> absent() {
        if (this.absent != null) {
            return this.absent;
        }
        this.absent = new LinkedHashMap<Integer, Integer>();
        do {
            Integer key = this.nextAbsentKey();
            this.absent.put(key, -key.intValue());
        } while (this.absent.size() < 10);
        return this.absent;
    }

    public Set<Integer> absentKeys() {
        return this.absent().keySet();
    }

    private Integer nextAbsentKey() {
        return ThreadLocalRandom.current().nextInt(0x3FFFFFFF, Integer.MAX_VALUE);
    }

    public long initialSize() {
        return this.initialSize < 0L ? (this.initialSize = (long)this.original.size()) : this.initialSize;
    }

    public CacheSpec.Maximum maximum() {
        return this.maximumSize;
    }

    public long maximumSize() {
        return this.maximumSize.max();
    }

    public long maximumWeight() {
        MatcherAssert.assertThat((String)"Invalid usage of context", (Object)this.isWeighted(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        long maximum = (long)this.weigher.unitsPerEntry() * this.maximumSize.max();
        return maximum < 0L ? Long.MAX_VALUE : maximum;
    }

    public long maximumWeightOrSize() {
        return this.isWeighted() ? this.maximumWeight() : this.maximumSize();
    }

    public CacheSpec.CacheWeigher weigher() {
        return this.weigher;
    }

    public boolean isWeighted() {
        return this.weigher != CacheSpec.CacheWeigher.DEFAULT;
    }

    public boolean isZeroWeighted() {
        return this.weigher == CacheSpec.CacheWeigher.ZERO;
    }

    public boolean isUnbounded() {
        return this.maximumSize == CacheSpec.Maximum.DISABLED;
    }

    public boolean refreshes() {
        return this.refresh != CacheSpec.Expire.DISABLED;
    }

    public CacheSpec.Expire refreshAfterWrite() {
        return this.refresh;
    }

    public Map<Integer, Integer> original() {
        this.initialSize();
        return this.original;
    }

    public boolean isStrongKeys() {
        return this.keyStrength == CacheSpec.ReferenceType.STRONG;
    }

    public boolean isWeakKeys() {
        return this.keyStrength == CacheSpec.ReferenceType.WEAK;
    }

    public boolean isStrongValues() {
        return this.valueStrength == CacheSpec.ReferenceType.STRONG;
    }

    public boolean isWeakValues() {
        return this.valueStrength == CacheSpec.ReferenceType.WEAK;
    }

    public boolean isSoftValues() {
        return this.valueStrength == CacheSpec.ReferenceType.SOFT;
    }

    public boolean isLoading() {
        return this.loader != null;
    }

    public boolean isAsyncLoading() {
        return this.isAsyncLoading;
    }

    public CacheSpec.Loader loader() {
        return this.loader;
    }

    public CacheSpec.Writer writer() {
        return this.writer;
    }

    public CacheWriter<Integer, Integer> cacheWriter() {
        return this.cacheWriter;
    }

    public boolean writes() {
        return this.writer != CacheSpec.Writer.DISABLED;
    }

    public void disableRejectingCacheWriter() {
        if (this.cacheWriter instanceof RejectingCacheWriter) {
            ((RejectingCacheWriter)this.cacheWriter).ignoreWrites();
        }
    }

    public void enableRejectingCacheWriter() {
        if (this.cacheWriter instanceof RejectingCacheWriter) {
            ((RejectingCacheWriter)this.cacheWriter).rejectWrites();
        }
    }

    public CacheSpec.Listener removalListenerType() {
        return this.removalListenerType;
    }

    public RemovalListener<Integer, Integer> removalListener() {
        return Objects.requireNonNull(this.removalListener);
    }

    public List<RemovalNotification<Integer, Integer>> consumedNotifications() {
        return this.removalListenerType() == CacheSpec.Listener.CONSUMING ? ((RemovalListeners.ConsumingRemovalListener)this.removalListener).evicted() : Collections.emptyList();
    }

    public boolean isRecordingStats() {
        return this.stats == CacheSpec.Stats.ENABLED;
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public Cache<?, ?> cache() {
        return this.cache;
    }

    public boolean expires(CacheSpec.Expiration expiration) {
        return this.expiresAfterAccess() && expiration == CacheSpec.Expiration.AFTER_ACCESS || this.expiresAfterWrite() && expiration == CacheSpec.Expiration.AFTER_WRITE || this.expiresVariably() && expiration == CacheSpec.Expiration.VARIABLE;
    }

    public boolean expires() {
        return this.expiresVariably() || this.expiresAfterAccess() || this.expiresAfterWrite();
    }

    public boolean expiresAfterAccess() {
        return this.afterAccess != CacheSpec.Expire.DISABLED;
    }

    public boolean expiresAfterWrite() {
        return this.afterWrite != CacheSpec.Expire.DISABLED;
    }

    public boolean expiresVariably() {
        return this.expiryType != CacheSpec.CacheExpiry.DISABLED;
    }

    public Expiry<Integer, Integer> expiry() {
        return this.expiry;
    }

    public CacheSpec.CacheExpiry expiryType() {
        return this.expiryType;
    }

    public CacheSpec.Expire expiryTime() {
        return this.expiryTime;
    }

    public CacheSpec.Expire expireAfterAccess() {
        return this.afterAccess;
    }

    public CacheSpec.Expire expireAfterWrite() {
        return this.afterWrite;
    }

    public FakeTicker ticker() {
        return this.ticker;
    }

    public <K, V> LoadingCache<K, V> build(CacheLoader<K, V> loader) {
        Object cache = this.isCaffeine() ? (this.isAsync() ? this.caffeine.buildAsync(loader).synchronous() : this.caffeine.build(loader)) : new GuavaCacheFromContext.GuavaLoadingCache(this.guava.build(com.google.common.cache.CacheLoader.asyncReloading(new GuavaCacheFromContext.SingleLoader<K, V>(loader), (Executor)this.executor)), (Ticker)this.ticker, this.isRecordingStats());
        this.cache = cache;
        return cache;
    }

    public <K, V> AsyncLoadingCache<K, V> buildAsync(CacheLoader<K, V> loader) {
        Preconditions.checkState((this.isCaffeine() && this.isAsync() ? 1 : 0) != 0);
        AsyncLoadingCache cache = this.caffeine.buildAsync(loader);
        this.cache = cache.synchronous();
        return cache;
    }

    public <K, V> AsyncLoadingCache<K, V> buildAsync(AsyncCacheLoader<K, V> loader) {
        Preconditions.checkState((this.isCaffeine() && this.isAsync() ? 1 : 0) != 0);
        AsyncLoadingCache cache = this.caffeine.buildAsync(loader);
        this.cache = cache.synchronous();
        return cache;
    }

    public CacheSpec.Implementation implementation() {
        return this.implementation;
    }

    public boolean isCaffeine() {
        return this.implementation == CacheSpec.Implementation.Caffeine;
    }

    public boolean isGuava() {
        return this.implementation == CacheSpec.Implementation.Guava;
    }

    public CacheSpec.CacheExecutor executorType() {
        return this.cacheExecutor;
    }

    public Executor executor() {
        return this.executor;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("population", (Object)this.population).add("maximumSize", (Object)this.maximumSize).add("weigher", (Object)this.weigher).add("expiry", (Object)this.expiryType).add("expiryTime", (Object)this.expiryTime).add("afterAccess", (Object)this.afterAccess).add("afterWrite", (Object)this.afterWrite).add("refreshAfterWrite", (Object)this.refresh).add("keyStrength", (Object)this.keyStrength).add("valueStrength", (Object)this.valueStrength).add("compute", (Object)this.compute).add("loader", (Object)this.loader).add("isAsyncLoading", this.isAsyncLoading).add("writer", (Object)this.writer).add("cacheExecutor", (Object)this.cacheExecutor).add("cacheScheduler", (Object)this.cacheScheduler).add("removalListener", (Object)this.removalListenerType).add("initialCapacity", (Object)this.initialCapacity).add("stats", (Object)this.stats).add("implementation", (Object)this.implementation).toString();
    }

    static final class SerializableFakeTicker
    extends FakeTicker
    implements Serializable {
        private static final long START_TIME = new Random().nextLong();

        public SerializableFakeTicker() {
            this.advance(START_TIME);
        }
    }
}

