/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CaffeineCacheFromContext;
import com.github.benmanes.caffeine.cache.testing.GuavaCacheFromContext;
import com.github.benmanes.caffeine.cache.testing.Options;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mockito.Mockito;

final class CacheGenerator {
    private static final List<Map.Entry<Integer, Integer>> INTS = CacheGenerator.makeInts();
    private static final int BASE = 1000;
    private final Options options;
    private final CacheSpec cacheSpec;
    private final boolean isAsyncOnly;
    private final boolean isLoadingOnly;

    public CacheGenerator(CacheSpec cacheSpec, Options options, boolean isLoadingOnly, boolean isAsyncOnly) {
        this.isLoadingOnly = isLoadingOnly;
        this.isAsyncOnly = isAsyncOnly;
        this.cacheSpec = cacheSpec;
        this.options = options;
    }

    public Stream<Map.Entry<CacheContext, Cache<Integer, Integer>>> generate() {
        return this.combinations().stream().map(this::newCacheContext).filter(this::isCompatible).map(context -> {
            Cache cache = CacheGenerator.newCache(context);
            this.populate((CacheContext)context, (Cache<Integer, Integer>)cache);
            return Maps.immutableEntry((Object)context, cache);
        });
    }

    private Set<List<Object>> combinations() {
        ImmutableSet asyncLoading = ImmutableSet.of((Object)true, (Object)false);
        Set<CacheSpec.Stats> statistics = CacheGenerator.filterTypes(this.options.stats(), this.cacheSpec.stats());
        Set<CacheSpec.ReferenceType> keys = CacheGenerator.filterTypes(this.options.keys(), this.cacheSpec.keys());
        ImmutableSet values = CacheGenerator.filterTypes(this.options.values(), this.cacheSpec.values());
        Set computations = CacheGenerator.filterTypes(this.options.compute(), this.cacheSpec.compute());
        ImmutableSet implementations = CacheGenerator.filterTypes(this.options.implementation(), this.cacheSpec.implementation());
        if (this.isAsyncOnly) {
            values = values.contains((Object)CacheSpec.ReferenceType.STRONG) ? ImmutableSet.of((Object)((Object)CacheSpec.ReferenceType.STRONG)) : ImmutableSet.of();
            computations = Sets.filter(computations, CacheSpec.Compute.ASYNC::equals);
        }
        if (this.isAsyncOnly || computations.equals(ImmutableSet.of((Object)((Object)CacheSpec.Compute.ASYNC)))) {
            ImmutableSet immutableSet = implementations = implementations.contains((Object)CacheSpec.Implementation.Caffeine) ? ImmutableSet.of((Object)((Object)CacheSpec.Implementation.Caffeine)) : ImmutableSet.of();
        }
        if (computations.equals(ImmutableSet.of((Object)((Object)CacheSpec.Compute.SYNC)))) {
            asyncLoading = ImmutableSet.of((Object)false);
        }
        if (computations.isEmpty() || implementations.isEmpty() || keys.isEmpty() || values.isEmpty()) {
            return ImmutableSet.of();
        }
        return Sets.cartesianProduct((Set[])new Set[]{ImmutableSet.copyOf((Object[])this.cacheSpec.initialCapacity()), ImmutableSet.copyOf(statistics), ImmutableSet.copyOf((Object[])this.cacheSpec.weigher()), ImmutableSet.copyOf((Object[])this.cacheSpec.maximumSize()), ImmutableSet.copyOf((Object[])this.cacheSpec.expiry()), ImmutableSet.copyOf((Object[])this.cacheSpec.expireAfterAccess()), ImmutableSet.copyOf((Object[])this.cacheSpec.expireAfterWrite()), ImmutableSet.copyOf((Object[])this.cacheSpec.refreshAfterWrite()), ImmutableSet.copyOf((Object[])this.cacheSpec.advanceOnPopulation()), ImmutableSet.copyOf(keys), ImmutableSet.copyOf((Collection)values), ImmutableSet.copyOf((Object[])this.cacheSpec.executor()), ImmutableSet.copyOf((Object[])this.cacheSpec.scheduler()), ImmutableSet.copyOf((Object[])this.cacheSpec.removalListener()), ImmutableSet.copyOf((Object[])this.cacheSpec.population()), ImmutableSet.of((Object)true, (Object)this.isLoadingOnly), ImmutableSet.copyOf((Collection)asyncLoading), ImmutableSet.copyOf((Collection)computations), ImmutableSet.copyOf((Object[])this.cacheSpec.loader()), ImmutableSet.copyOf((Object[])this.cacheSpec.writer()), ImmutableSet.copyOf((Collection)implementations)});
    }

    private static <T> Set<T> filterTypes(Optional<T> type, T[] options) {
        if (type.isPresent()) {
            return type.filter(Arrays.asList(options)::contains).isPresent() ? ImmutableSet.of(type.get()) : ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Object[])options);
    }

    private CacheContext newCacheContext(List<Object> combination) {
        int index = 0;
        return new CacheContext((CacheSpec.InitialCapacity)((Object)combination.get(index++)), (CacheSpec.Stats)((Object)combination.get(index++)), (CacheSpec.CacheWeigher)((Object)combination.get(index++)), (CacheSpec.Maximum)((Object)combination.get(index++)), (CacheSpec.CacheExpiry)((Object)combination.get(index++)), (CacheSpec.Expire)((Object)combination.get(index++)), (CacheSpec.Expire)((Object)combination.get(index++)), (CacheSpec.Expire)((Object)combination.get(index++)), (CacheSpec.Advance)((Object)combination.get(index++)), (CacheSpec.ReferenceType)((Object)combination.get(index++)), (CacheSpec.ReferenceType)((Object)combination.get(index++)), (CacheSpec.CacheExecutor)((Object)combination.get(index++)), (CacheSpec.CacheScheduler)((Object)combination.get(index++)), (CacheSpec.Listener)((Object)combination.get(index++)), (CacheSpec.Population)((Object)combination.get(index++)), (Boolean)combination.get(index++), (Boolean)combination.get(index++), (CacheSpec.Compute)((Object)combination.get(index++)), (CacheSpec.Loader)((Object)combination.get(index++)), (CacheSpec.Writer)((Object)combination.get(index++)), (CacheSpec.Implementation)((Object)combination.get(index++)), this.cacheSpec);
    }

    /*
     * Unable to fully structure code
     */
    private boolean isCompatible(CacheContext context) {
        asyncIncompatible = context.isAsync() != false && (context.implementation() != CacheSpec.Implementation.Caffeine || context.isStrongValues() == false);
        asyncLoaderIncompatible = context.isAsyncLoading() != false && (context.isAsync() == false || context.isLoading() == false);
        refreshIncompatible = context.refreshes() != false && context.isLoading() == false;
        weigherIncompatible = context.isUnbounded() != false && context.isWeighted() != false;
        referenceIncompatible = this.cacheSpec.requiresWeakOrSoft() != false && context.isStrongKeys() != false && context.isStrongValues() != false;
        v0 = expiryIncompatible = context.expiryType() != CacheSpec.CacheExpiry.DISABLED && (context.implementation() != CacheSpec.Implementation.Caffeine || context.expireAfterAccess() != CacheSpec.Expire.DISABLED || context.expireAfterWrite() != CacheSpec.Expire.DISABLED);
        if (this.cacheSpec.mustExpireWithAnyOf().length <= 0) ** GOTO lbl-1000
        if (!Arrays.stream(this.cacheSpec.mustExpireWithAnyOf()).anyMatch((Predicate<CacheSpec.Expiration>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, expires(com.github.benmanes.caffeine.cache.testing.CacheSpec$Expiration ), (Lcom/github/benmanes/caffeine/cache/testing/CacheSpec$Expiration;)Z)((CacheContext)context))) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        expirationIncompatible = v1;
        schedulerIgnored = context.cacheScheduler != CacheSpec.CacheScheduler.DEFAULT && context.expires() == false;
        skip = asyncIncompatible != false || asyncLoaderIncompatible != false || refreshIncompatible != false || weigherIncompatible != false || expiryIncompatible != false || expirationIncompatible != false || referenceIncompatible != false || schedulerIgnored != false;
        return skip == false;
    }

    public static <K, V> Cache<K, V> newCache(CacheContext context) {
        switch (context.implementation()) {
            case Caffeine: {
                return CaffeineCacheFromContext.newCaffeineCache(context);
            }
            case Guava: {
                return GuavaCacheFromContext.newGuavaCache(context);
            }
        }
        throw new IllegalStateException();
    }

    private void populate(CacheContext context, Cache<Integer, Integer> cache) {
        if (context.population.size() == 0L) {
            return;
        }
        int maximum = (int)Math.min(context.maximumSize(), context.population.size());
        int first = 1000 + (int)Math.min(0L, context.population.size());
        int last = 1000 + maximum - 1;
        int middle = Math.max(first, 1000 + (last - first) / 2);
        context.disableRejectingCacheWriter();
        for (int i = 0; i < maximum; ++i) {
            Integer value;
            Map.Entry<Integer, Integer> entry = INTS.get(i);
            Integer key = context.isStrongKeys() ? entry.getKey() : new Integer(1000 + i);
            Integer n = value = context.isStrongValues() ? entry.getValue() : new Integer(-key.intValue());
            if (key == first) {
                context.firstKey = key;
            }
            if (key == middle) {
                context.middleKey = key;
            }
            if (key == last) {
                context.lastKey = key;
            }
            cache.put((Object)key, (Object)value);
            context.original.put(key, value);
            context.ticker().advance(context.advance.timeNanos(), TimeUnit.NANOSECONDS);
        }
        context.enableRejectingCacheWriter();
        if (context.writer() == CacheSpec.Writer.MOCKITO) {
            Mockito.reset((Object[])new CacheWriter[]{context.cacheWriter()});
        }
    }

    private static List<Map.Entry<Integer, Integer>> makeInts() {
        int size = Stream.of(CacheSpec.Population.values()).mapToInt(population -> Math.toIntExact(population.size())).max().getAsInt();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            int value = 1000 + i;
            builder.add((Object)Maps.immutableEntry((Object)new Integer(value), (Object)new Integer(-value)));
        }
        return builder.build();
    }
}

