/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheGenerator;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.ExpireAfterAccess;
import com.github.benmanes.caffeine.cache.testing.ExpireAfterWrite;
import com.github.benmanes.caffeine.cache.testing.Options;
import com.github.benmanes.caffeine.cache.testing.RefreshAfterWrite;
import com.google.common.base.Preconditions;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.LogManager;
import java.util.stream.Stream;
import org.testng.annotations.DataProvider;

public final class CacheProvider {
    private CacheProvider() {
    }

    @DataProvider(name="caches")
    public static Iterator<Object[]> providesCaches(Method testMethod) throws Exception {
        CacheGenerator generator = CacheProvider.newCacheGenerator(testMethod);
        return CacheProvider.asTestCases(testMethod, generator.generate());
    }

    /*
     * Unable to fully structure code
     */
    private static CacheGenerator newCacheGenerator(Method testMethod) {
        cacheSpec = testMethod.getAnnotation(CacheSpec.class);
        Objects.requireNonNull(cacheSpec, "@CacheSpec not found");
        options = Options.fromSystemProperties();
        isAsyncOnly = CacheProvider.hasCacheOfType(testMethod, AsyncCache.class);
        if (CacheProvider.hasCacheOfType(testMethod, LoadingCache.class) || CacheProvider.hasCacheOfType(testMethod, AsyncLoadingCache.class)) ** GOTO lbl-1000
        if (options.compute().filter((Predicate<CacheSpec.Compute>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lcom/github/benmanes/caffeine/cache/testing/CacheSpec$Compute;)Z)((CacheSpec.Compute)CacheSpec.Compute.ASYNC)).isPresent()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        isLoadingOnly = v0;
        return new CacheGenerator(cacheSpec, options, isLoadingOnly, isAsyncOnly);
    }

    private static Iterator<Object[]> asTestCases(Method testMethod, Stream<Map.Entry<CacheContext, Cache<Integer, Integer>>> scenarios) {
        Parameter[] parameters = testMethod.getParameters();
        CacheContext[] stashed = new CacheContext[1];
        return scenarios.map(entry -> {
            CacheContext context = (CacheContext)entry.getKey();
            Cache cache = (Cache)entry.getValue();
            stashed[0] = context;
            Object[] params = new Object[parameters.length];
            for (int i = 0; i < params.length; ++i) {
                Class<Object> clazz = parameters[i].getType();
                if (clazz.isAssignableFrom(CacheContext.class)) {
                    params[i] = context;
                } else if (clazz.isAssignableFrom(Caffeine.class)) {
                    params[i] = context.caffeine;
                } else if (clazz.isAssignableFrom(cache.getClass())) {
                    params[i] = cache;
                } else if (context.asyncCache != null && clazz.isAssignableFrom(context.asyncCache.getClass())) {
                    params[i] = context.asyncCache;
                } else if (clazz.isAssignableFrom(Map.class)) {
                    params[i] = cache.asMap();
                } else if (clazz.isAssignableFrom(Policy.Eviction.class)) {
                    params[i] = cache.policy().eviction().get();
                } else if (clazz.isAssignableFrom(Policy.Expiration.class)) {
                    params[i] = CacheProvider.expirationPolicy(parameters[i], (Cache<Integer, Integer>)cache);
                } else if (clazz.isAssignableFrom(Policy.VarExpiration.class)) {
                    params[i] = cache.policy().expireVariably().get();
                }
                if (params[i] != null) continue;
                Preconditions.checkNotNull((Object)params[i], (String)"Unknown parameter type: %s", clazz);
            }
            return params;
        }).filter(Objects::nonNull).iterator();
    }

    private static Policy.Expiration<Integer, Integer> expirationPolicy(Parameter parameter, Cache<Integer, Integer> cache) {
        if (parameter.isAnnotationPresent(ExpireAfterAccess.class)) {
            return (Policy.Expiration)cache.policy().expireAfterAccess().get();
        }
        if (parameter.isAnnotationPresent(ExpireAfterWrite.class)) {
            return (Policy.Expiration)cache.policy().expireAfterWrite().get();
        }
        if (parameter.isAnnotationPresent(RefreshAfterWrite.class)) {
            return (Policy.Expiration)cache.policy().refreshAfterWrite().get();
        }
        throw new AssertionError((Object)"Expiration parameter must have a qualifier annotation");
    }

    private static boolean hasCacheOfType(Method testMethod, Class<?> cacheType) {
        return Arrays.stream(testMethod.getParameterTypes()).anyMatch(cacheType::isAssignableFrom);
    }

    static {
        LogManager.getLogManager().reset();
    }
}

