/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.testing.ExpiryBuilder;
import com.github.benmanes.caffeine.cache.testing.RejectingCacheWriter;
import com.github.benmanes.caffeine.cache.testing.RemovalListeners;
import com.github.benmanes.caffeine.cache.testing.TrackingExecutor;
import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface CacheSpec {
    public static final ThreadLocal<Map<Integer, Integer>> interner = ThreadLocal.withInitial(HashMap::new);
    public static final ExecutorService cachedExecutorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build());

    public Compute[] compute() default {Compute.ASYNC, Compute.SYNC};

    public Implementation[] implementation() default {Implementation.Caffeine, Implementation.Guava};

    public InitialCapacity[] initialCapacity() default {InitialCapacity.DEFAULT};

    public Stats[] stats() default {Stats.ENABLED, Stats.DISABLED};

    public Maximum[] maximumSize() default {Maximum.DISABLED, Maximum.UNREACHABLE};

    public CacheWeigher[] weigher() default {CacheWeigher.DEFAULT, CacheWeigher.ZERO, CacheWeigher.TEN};

    public Expiration[] mustExpireWithAnyOf() default {};

    public Expire[] expireAfterAccess() default {Expire.DISABLED, Expire.FOREVER};

    public Expire[] expireAfterWrite() default {Expire.DISABLED, Expire.FOREVER};

    public Expire[] refreshAfterWrite() default {Expire.DISABLED, Expire.FOREVER};

    public CacheExpiry[] expiry() default {CacheExpiry.DISABLED, CacheExpiry.ACCESS};

    public Expire expiryTime() default Expire.FOREVER;

    public Advance[] advanceOnPopulation() default {Advance.ZERO};

    public boolean requiresWeakOrSoft() default false;

    public ReferenceType[] keys() default {ReferenceType.STRONG, ReferenceType.WEAK};

    public ReferenceType[] values() default {ReferenceType.STRONG, ReferenceType.WEAK, ReferenceType.SOFT};

    public Listener[] removalListener() default {Listener.CONSUMING, Listener.DEFAULT};

    public Loader[] loader() default {Loader.NEGATIVE};

    public Writer[] writer() default {Writer.MOCKITO};

    public CacheExecutor[] executor() default {CacheExecutor.DIRECT};

    public ExecutorFailure executorFailure() default ExecutorFailure.DISALLOWED;

    public CacheScheduler[] scheduler() default {CacheScheduler.DEFAULT};

    public Population[] population() default {Population.EMPTY, Population.SINGLETON, Population.PARTIAL, Population.FULL};

    public static enum Population {
        EMPTY(0L),
        SINGLETON(1L),
        PARTIAL(InitialCapacity.FULL.size() / 2),
        FULL(InitialCapacity.FULL.size());

        private final long size;

        private Population(long size) {
            this.size = size;
        }

        public long size() {
            return this.size;
        }
    }

    public static enum CacheScheduler {
        DEFAULT(() -> null),
        SYSTEM(Scheduler::systemScheduler),
        THREADED(() -> Scheduler.forScheduledExecutorService((ScheduledExecutorService)ConcurrentTestHarness.scheduledExecutor)),
        MOCK(() -> (Scheduler)Mockito.mock(Scheduler.class));

        private final Supplier<Scheduler> scheduler;

        private CacheScheduler(Supplier<Scheduler> scheduler) {
            this.scheduler = Objects.requireNonNull(scheduler);
        }

        public Scheduler create() {
            return this.scheduler.get();
        }
    }

    public static enum CacheExecutor {
        DEFAULT{

            @Override
            public Executor create() {
                return null;
            }
        }
        ,
        DIRECT{

            @Override
            public Executor create() {
                return new TrackingExecutor((ExecutorService)MoreExecutors.newDirectExecutorService());
            }
        }
        ,
        THREADED{

            @Override
            public Executor create() {
                return new TrackingExecutor(cachedExecutorService);
            }
        }
        ,
        REJECTING{

            @Override
            public Executor create() {
                return new ForkJoinPool(){

                    @Override
                    public void execute(Runnable task) {
                        throw new RejectedExecutionException();
                    }
                };
            }
        };


        public abstract Executor create();
    }

    public static enum ExecutorFailure {
        EXPECTED,
        DISALLOWED,
        IGNORED;

    }

    public static enum Writer {
        DISABLED{

            @Override
            public <K, V> CacheWriter<K, V> create() {
                return CacheWriter.disabledWriter();
            }
        }
        ,
        MOCKITO{

            @Override
            public <K, V> CacheWriter<K, V> create() {
                CacheWriter mock = (CacheWriter)Mockito.mock(CacheWriter.class);
                return mock;
            }
        }
        ,
        EXCEPTIONAL{

            @Override
            public <K, V> CacheWriter<K, V> create() {
                return new RejectingCacheWriter();
            }
        };


        public abstract <K, V> CacheWriter<K, V> create();
    }

    public static enum Loader implements CacheLoader<Integer, Integer>
    {
        NULL{

            public Integer load(Integer key) {
                return null;
            }
        }
        ,
        IDENTITY{

            public Integer load(Integer key) {
                Objects.requireNonNull(key);
                return key;
            }
        }
        ,
        NEGATIVE{

            public Integer load(Integer key) {
                return interner.get().computeIfAbsent(key, k -> -k.intValue());
            }
        }
        ,
        EXCEPTIONAL{

            public Integer load(Integer key) {
                throw new IllegalStateException();
            }
        }
        ,
        BULK_NULL{

            public Integer load(Integer key) {
                throw new UnsupportedOperationException();
            }

            public Map<Integer, Integer> loadAll(Iterable<? extends Integer> keys) {
                return null;
            }
        }
        ,
        BULK_IDENTITY{

            public Integer load(Integer key) {
                throw new UnsupportedOperationException();
            }

            public Map<Integer, Integer> loadAll(Iterable<? extends Integer> keys) {
                HashMap<Integer, Integer> result = new HashMap<Integer, Integer>(Iterables.size(keys));
                for (Integer n : keys) {
                    result.put(n, n);
                }
                return result;
            }
        }
        ,
        BULK_NEGATIVE{

            public Integer load(Integer key) {
                throw new UnsupportedOperationException();
            }

            public Map<Integer, Integer> loadAll(Iterable<? extends Integer> keys) {
                HashMap<Integer, Integer> result = new HashMap<Integer, Integer>(Iterables.size(keys));
                for (Integer n : keys) {
                    result.put(n, interner.get().computeIfAbsent(n, k -> -k.intValue()));
                }
                return result;
            }
        }
        ,
        BULK_NEGATIVE_EXCEEDS{

            public Integer load(Integer key) {
                throw new UnsupportedOperationException();
            }

            public Map<Integer, Integer> loadAll(Iterable<? extends Integer> keys) throws Exception {
                ArrayList<Integer> moreKeys = new ArrayList<Integer>(Iterables.size(keys) + 10);
                Iterables.addAll(moreKeys, keys);
                for (int i = 0; i < 10; ++i) {
                    moreKeys.add(ThreadLocalRandom.current().nextInt());
                }
                return BULK_NEGATIVE.loadAll(moreKeys);
            }
        }
        ,
        BULK_EXCEPTIONAL{

            public Integer load(Integer key) {
                throw new UnsupportedOperationException();
            }

            public Map<Integer, Integer> loadAll(Iterable<? extends Integer> keys) {
                throw new IllegalStateException();
            }
        };

        private final boolean bulk = this.name().startsWith("BULK");
        private final AsyncCacheLoader<Integer, Integer> asyncLoader = this.bulk ? new BulkSeriazableAsyncCacheLoader(this) : new SeriazableAsyncCacheLoader(this);

        public boolean isBulk() {
            return this.bulk;
        }

        public AsyncCacheLoader<Integer, Integer> async() {
            return this.asyncLoader;
        }

        private static final class BulkSeriazableAsyncCacheLoader
        extends SeriazableAsyncCacheLoader {
            private static final long serialVersionUID = 1L;

            BulkSeriazableAsyncCacheLoader(Loader loader) {
                super(loader);
            }

            @Override
            public CompletableFuture<Integer> asyncLoad(Integer key, Executor executor) {
                throw new IllegalStateException();
            }

            public CompletableFuture<Map<Integer, Integer>> asyncLoadAll(Iterable<? extends Integer> keys, Executor executor) {
                return this.loader.asyncLoadAll(keys, executor);
            }
        }

        private static class SeriazableAsyncCacheLoader
        implements AsyncCacheLoader<Integer, Integer>,
        Serializable {
            private static final long serialVersionUID = 1L;
            final Loader loader;

            SeriazableAsyncCacheLoader(Loader loader) {
                this.loader = loader;
            }

            public CompletableFuture<Integer> asyncLoad(Integer key, Executor executor) {
                return this.loader.asyncLoad(key, executor);
            }

            private Object readResolve() throws ObjectStreamException {
                return this.loader.asyncLoader;
            }
        }
    }

    public static enum Listener {
        DEFAULT{

            @Override
            public <K, V> RemovalListener<K, V> create() {
                return null;
            }
        }
        ,
        REJECTING{

            @Override
            public <K, V> RemovalListener<K, V> create() {
                return RemovalListeners.rejecting();
            }
        }
        ,
        CONSUMING{

            @Override
            public <K, V> RemovalListener<K, V> create() {
                return RemovalListeners.consuming();
            }
        };


        public abstract <K, V> RemovalListener<K, V> create();
    }

    public static enum ReferenceType {
        STRONG,
        WEAK,
        SOFT;

    }

    public static enum Advance {
        ZERO(0L),
        ONE_MINUTE(TimeUnit.MINUTES.toNanos(1L));

        private final long timeNanos;

        private Advance(long timeNanos) {
            this.timeNanos = timeNanos;
        }

        public long timeNanos() {
            return this.timeNanos;
        }
    }

    public static enum Expire {
        DISABLED(Long.MIN_VALUE),
        IMMEDIATELY(0L),
        ONE_MILLISECOND(TimeUnit.MILLISECONDS.toNanos(1L)),
        ONE_MINUTE(TimeUnit.MINUTES.toNanos(1L)),
        FOREVER(Long.MAX_VALUE);

        private final long timeNanos;

        private Expire(long timeNanos) {
            this.timeNanos = timeNanos;
        }

        public long timeNanos() {
            return this.timeNanos;
        }
    }

    public static enum CacheExpiry {
        DISABLED{

            @Override
            public <K, V> Expiry<K, V> createExpiry(Expire expiryTime) {
                return null;
            }
        }
        ,
        MOCKITO{

            @Override
            public <K, V> Expiry<K, V> createExpiry(Expire expiryTime) {
                Expiry mock = (Expiry)Mockito.mock(Expiry.class);
                Mockito.when((Object)mock.expireAfterCreate(ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenReturn((Object)expiryTime.timeNanos());
                Mockito.when((Object)mock.expireAfterUpdate(ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)expiryTime.timeNanos());
                Mockito.when((Object)mock.expireAfterRead(ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)expiryTime.timeNanos());
                return mock;
            }
        }
        ,
        CREATE{

            @Override
            public <K, V> Expiry<K, V> createExpiry(Expire expiryTime) {
                return ExpiryBuilder.expiringAfterCreate(expiryTime.timeNanos()).build();
            }
        }
        ,
        WRITE{

            @Override
            public <K, V> Expiry<K, V> createExpiry(Expire expiryTime) {
                return ExpiryBuilder.expiringAfterCreate(expiryTime.timeNanos()).expiringAfterUpdate(expiryTime.timeNanos()).build();
            }
        }
        ,
        ACCESS{

            @Override
            public <K, V> Expiry<K, V> createExpiry(Expire expiryTime) {
                return ExpiryBuilder.expiringAfterCreate(expiryTime.timeNanos()).expiringAfterUpdate(expiryTime.timeNanos()).expiringAfterRead(expiryTime.timeNanos()).build();
            }
        };


        public abstract <K, V> Expiry<K, V> createExpiry(Expire var1);
    }

    public static enum Expiration {
        AFTER_WRITE,
        AFTER_ACCESS,
        VARIABLE;

    }

    public static enum CacheWeigher implements Weigher<Object, Object>
    {
        DEFAULT(1),
        TEN(10),
        ZERO(0),
        NEGATIVE(-1),
        MAX_VALUE(Integer.MAX_VALUE),
        VALUE(1){

            @Override
            public int weigh(Object key, Object value) {
                Objects.requireNonNull(key);
                return (Integer)value;
            }
        }
        ,
        COLLECTION(1){

            @Override
            public int weigh(Object key, Object value) {
                Objects.requireNonNull(key);
                return ((Collection)value).size();
            }
        }
        ,
        RANDOM(1){

            @Override
            public int weigh(Object key, Object value) {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                return ThreadLocalRandom.current().nextInt(1, 10);
            }
        };

        private final int units;

        private CacheWeigher(int multiplier) {
            this.units = multiplier;
        }

        public int weigh(Object key, Object value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            return this.units;
        }

        public int unitsPerEntry() {
            return this.units;
        }
    }

    public static enum Maximum {
        DISABLED(Long.MAX_VALUE),
        ZERO(0L),
        ONE(1L),
        TEN(10L),
        ONE_FIFTY(150L),
        FULL(InitialCapacity.FULL.size()),
        UNREACHABLE(Long.MAX_VALUE);

        private final long max;

        private Maximum(long max) {
            this.max = max;
        }

        public long max() {
            return this.max;
        }
    }

    public static enum Stats {
        ENABLED,
        DISABLED;

    }

    public static enum InitialCapacity {
        DEFAULT(16),
        ZERO(0),
        ONE(1),
        FULL(50),
        EXCESSIVE(100);

        private final int size;

        private InitialCapacity(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }
    }

    public static enum Implementation {
        Caffeine,
        Guava;

    }

    public static enum Compute {
        ASYNC,
        SYNC;

    }
}

