/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.IsValidAsyncCache;
import com.github.benmanes.caffeine.cache.IsValidCache;
import com.github.benmanes.caffeine.cache.IsValidMapView;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.CacheWriterVerifier;
import com.github.benmanes.caffeine.cache.testing.CheckNoStats;
import com.github.benmanes.caffeine.cache.testing.CheckNoWriter;
import com.github.benmanes.caffeine.cache.testing.HasStats;
import com.github.benmanes.caffeine.cache.testing.TrackingExecutor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;

public final class CacheValidationListener
implements IInvokedMethodListener {
    private static final Cache<Object, String> simpleNames = Caffeine.newBuilder().build();
    private static final AtomicBoolean detailedParams = new AtomicBoolean();

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        try {
            if (testResult.isSuccess()) {
                this.validate(testResult);
            } else {
                if (!detailedParams.get()) {
                    detailedParams.set(true);
                }
                testResult.setThrowable((Throwable)((Object)new AssertionError(CacheValidationListener.getTestName(method), testResult.getThrowable())));
            }
        }
        catch (Throwable caught) {
            testResult.setStatus(2);
            testResult.setThrowable((Throwable)((Object)new AssertionError(CacheValidationListener.getTestName(method), caught)));
        }
        finally {
            this.cleanUp(testResult);
        }
    }

    private void validate(ITestResult testResult) {
        boolean foundCache = false;
        CacheContext context = null;
        for (Object param : testResult.getParameters()) {
            if (param instanceof Cache) {
                foundCache = true;
                MatcherAssert.assertThat((Object)((Cache)param), (Matcher)Matchers.is(IsValidCache.validCache()));
                continue;
            }
            if (param instanceof AsyncLoadingCache) {
                foundCache = true;
                MatcherAssert.assertThat((Object)((AsyncLoadingCache)param), (Matcher)Matchers.is(IsValidAsyncCache.validAsyncCache()));
                continue;
            }
            if (param instanceof Map) {
                foundCache = true;
                MatcherAssert.assertThat((Object)((Map)param), (Matcher)Matchers.is(IsValidMapView.validAsMap()));
                continue;
            }
            if (!(param instanceof CacheContext)) continue;
            context = (CacheContext)param;
        }
        if (context != null) {
            if (!foundCache) {
                MatcherAssert.assertThat(context.cache, (Matcher)Matchers.is(IsValidCache.validCache()));
            }
            CacheValidationListener.checkWriter(testResult, context);
            CacheValidationListener.checkNoStats(testResult, context);
            CacheValidationListener.checkExecutor(testResult, context);
        }
    }

    private static String getTestName(IInvokedMethod method) {
        return StringUtils.substringAfterLast((String)method.getTestMethod().getTestClass().getName(), (String)".") + "#" + method.getTestMethod().getConstructorOrMethod().getName();
    }

    private static void checkExecutor(ITestResult testResult, CacheContext context) {
        Method testMethod = testResult.getMethod().getConstructorOrMethod().getMethod();
        CacheSpec cacheSpec = testMethod.getAnnotation(CacheSpec.class);
        if (cacheSpec == null) {
            return;
        }
        MatcherAssert.assertThat((String)"CacheContext required", (Object)context, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        if (!(context.executor() instanceof TrackingExecutor)) {
            return;
        }
        TrackingExecutor executor = (TrackingExecutor)((Object)context.executor());
        if (cacheSpec.executorFailure() == CacheSpec.ExecutorFailure.EXPECTED) {
            MatcherAssert.assertThat((Object)executor.failureCount(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        } else if (cacheSpec.executorFailure() == CacheSpec.ExecutorFailure.DISALLOWED) {
            MatcherAssert.assertThat((Object)executor.failureCount(), (Matcher)Matchers.is((Object)0));
        }
    }

    private static void checkWriter(ITestResult testResult, CacheContext context) {
        Method testMethod = testResult.getMethod().getConstructorOrMethod().getMethod();
        CheckNoWriter checkWriter = testMethod.getAnnotation(CheckNoWriter.class);
        if (checkWriter == null) {
            return;
        }
        MatcherAssert.assertThat((String)"Test requires CacheContext param for validation", (Object)context, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        CacheWriterVerifier.verifyWriter(context, (verifier, writer) -> verifier.zeroInteractions());
    }

    private static void checkNoStats(ITestResult testResult, CacheContext context) {
        Method testMethod = testResult.getMethod().getConstructorOrMethod().getMethod();
        boolean checkNoStats = testMethod.isAnnotationPresent(CheckNoStats.class);
        if (!checkNoStats) {
            return;
        }
        MatcherAssert.assertThat((String)"Test requires CacheContext param for validation", (Object)context, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasHitCount(0L));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasMissCount(0L));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasLoadSuccessCount(0L));
        MatcherAssert.assertThat((Object)context, (Matcher)HasStats.hasLoadFailureCount(0L));
    }

    private void cleanUp(ITestResult testResult) {
        Object[] params = testResult.getParameters();
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            params[i] = param instanceof AsyncCache || param instanceof Cache || param instanceof Map || param instanceof Policy.Eviction || param instanceof Policy.Expiration || param instanceof Policy.VarExpiration || param instanceof CacheContext && !detailedParams.get() ? simpleNames.get(param.getClass(), key -> ((Class)key).getSimpleName()) : (param instanceof CacheContext ? simpleNames.get((Object)param.toString(), Object::toString) : Objects.toString(param));
        }
        CacheSpec.interner.get().clear();
    }
}

