/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class CacheWriterVerifier {
    private final CacheContext context;

    private CacheWriterVerifier(CacheContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public void zeroInteractions() {
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.context.cacheWriter()});
    }

    public void writes(int count) {
        ((CacheWriter)Mockito.verify(this.context.cacheWriter(), (VerificationMode)Mockito.times((int)count))).write((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()));
    }

    public void wrote(Integer key, Integer value) {
        ((CacheWriter)Mockito.verify(this.context.cacheWriter())).write((Object)((Integer)ArgumentMatchers.eq((Object)key)), (Object)((Integer)ArgumentMatchers.eq((Object)value)));
    }

    public void wroteAll(Map<Integer, Integer> map) {
        map.entrySet().forEach(entry -> this.wrote((Integer)entry.getKey(), (Integer)entry.getValue()));
        ((CacheWriter)Mockito.verify(this.context.cacheWriter(), (VerificationMode)Mockito.times((int)map.size()))).write((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()));
    }

    public void deletions(long count) {
        ((CacheWriter)Mockito.verify(this.context.cacheWriter(), (VerificationMode)Mockito.times((int)((int)count)))).delete((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), (RemovalCause)ArgumentMatchers.any());
    }

    public void deletions(long count, RemovalCause cause) {
        ((CacheWriter)Mockito.verify(this.context.cacheWriter(), (VerificationMode)Mockito.times((int)((int)count)))).delete((Object)((Integer)ArgumentMatchers.any()), (Object)((Integer)ArgumentMatchers.any()), (RemovalCause)ArgumentMatchers.eq((Object)cause));
    }

    public void deleted(Map.Entry<Integer, Integer> entry, RemovalCause cause) {
        this.deleted(entry.getKey(), entry.getValue(), cause);
    }

    public void deleted(Integer key, Integer value, RemovalCause cause) {
        ((CacheWriter)Mockito.verify(this.context.cacheWriter())).delete((Object)((Integer)ArgumentMatchers.eq((Object)key)), (Object)((Integer)ArgumentMatchers.eq((Object)value)), (RemovalCause)ArgumentMatchers.eq((Object)cause));
    }

    public void deletedAll(Map<Integer, Integer> map, RemovalCause cause) {
        map.entrySet().forEach(entry -> this.deleted((Map.Entry<Integer, Integer>)entry, cause));
        this.deletions(map.size());
    }

    public static void verifyWriter(CacheContext context, BiConsumer<CacheWriterVerifier, CacheWriter<Integer, Integer>> consumer) {
        boolean mayVerify;
        boolean bl = mayVerify = context.isCaffeine() && context.isStrongKeys() && !context.isAsync();
        if (mayVerify) {
            consumer.accept(new CacheWriterVerifier(context), context.cacheWriter());
        }
    }
}

