/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RandomSeedEnforcer;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.google.common.testing.FakeTicker;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public final class CaffeineCacheFromContext {
    private CaffeineCacheFromContext() {
    }

    public static <K, V> Cache<K, V> newCaffeineCache(CacheContext context) {
        Caffeine builder;
        block25: {
            block24: {
                context.caffeine = builder = Caffeine.newBuilder();
                if (context.initialCapacity != CacheSpec.InitialCapacity.DEFAULT) {
                    builder.initialCapacity(context.initialCapacity.size());
                }
                if (context.isRecordingStats()) {
                    builder.recordStats();
                }
                if (context.maximumSize != CacheSpec.Maximum.DISABLED) {
                    if (context.weigher == CacheSpec.CacheWeigher.DEFAULT) {
                        builder.maximumSize(context.maximumSize.max());
                    } else {
                        builder.weigher((Weigher)context.weigher);
                        builder.maximumWeight(context.maximumWeight());
                    }
                }
                if (context.expiryType() != CacheSpec.CacheExpiry.DISABLED) {
                    builder.expireAfter(context.expiry);
                }
                if (context.afterAccess != CacheSpec.Expire.DISABLED) {
                    builder.expireAfterAccess(context.afterAccess.timeNanos(), TimeUnit.NANOSECONDS);
                }
                if (context.afterWrite != CacheSpec.Expire.DISABLED) {
                    builder.expireAfterWrite(context.afterWrite.timeNanos(), TimeUnit.NANOSECONDS);
                }
                if (context.refresh != CacheSpec.Expire.DISABLED) {
                    builder.refreshAfterWrite(context.refresh.timeNanos(), TimeUnit.NANOSECONDS);
                }
                if (context.expires()) break block24;
                if (!context.refreshes()) break block25;
            }
            SerializableTicker ticker = () -> ((FakeTicker)context.ticker()).read();
            builder.ticker((Ticker)ticker);
        }
        if (context.keyStrength == CacheSpec.ReferenceType.WEAK) {
            builder.weakKeys();
        } else if (context.keyStrength == CacheSpec.ReferenceType.SOFT) {
            throw new IllegalStateException();
        }
        if (context.isWeakValues()) {
            builder.weakValues();
        } else if (context.isSoftValues()) {
            builder.softValues();
        }
        if (context.cacheExecutor != CacheSpec.CacheExecutor.DEFAULT) {
            builder.executor(context.executor);
        }
        if (context.cacheScheduler != CacheSpec.CacheScheduler.DEFAULT) {
            builder.scheduler(context.scheduler);
        }
        if (context.removalListenerType != CacheSpec.Listener.DEFAULT) {
            builder.removalListener(context.removalListener);
        }
        if (context.isStrongKeys() && !context.isAsync()) {
            builder.writer(context.cacheWriter());
        }
        if (context.isAsync()) {
            context.asyncCache = context.loader == null ? builder.buildAsync() : builder.buildAsync(context.isAsyncLoading ? context.loader.async() : context.loader);
            context.cache = context.asyncCache.synchronous();
        } else {
            context.cache = context.loader == null ? builder.build() : builder.build((CacheLoader)context.loader);
        }
        Cache<?, ?> castedCache = context.cache;
        RandomSeedEnforcer.resetThreadLocalRandom();
        return castedCache;
    }

    static interface SerializableTicker
    extends Ticker,
    Serializable {
    }
}

