/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.Expiry;
import java.io.Serializable;
import java.util.Objects;

public final class ExpiryBuilder {
    static final int UNSET = -1;
    private long createNanos = -1L;
    private long updateNanos = -1L;
    private long readNanos = -1L;

    private ExpiryBuilder(long createNanos) {
        this.createNanos = createNanos;
    }

    public static ExpiryBuilder expiringAfterCreate(long nanos) {
        return new ExpiryBuilder(nanos);
    }

    public ExpiryBuilder expiringAfterUpdate(long nanos) {
        this.updateNanos = nanos;
        return this;
    }

    public ExpiryBuilder expiringAfterRead(long nanos) {
        this.readNanos = nanos;
        return this;
    }

    public <K, V> Expiry<K, V> build() {
        return new FixedExpiry(this.createNanos, this.updateNanos, this.readNanos);
    }

    private static final class FixedExpiry<K, V>
    implements Expiry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long createNanos;
        private final long updateNanos;
        private final long readNanos;

        FixedExpiry(long createNanos, long updateNanos, long readNanos) {
            this.createNanos = createNanos;
            this.updateNanos = updateNanos;
            this.readNanos = readNanos;
        }

        public long expireAfterCreate(K key, V value, long currentTime) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            return this.createNanos;
        }

        public long expireAfterUpdate(K key, V value, long currentTime, long currentDuration) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            return this.updateNanos == -1L ? currentDuration : this.updateNanos;
        }

        public long expireAfterRead(K key, V value, long currentTime, long currentDuration) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            return this.readNanos == -1L ? currentDuration : this.readNanos;
        }
    }
}

