/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ForwardingConcurrentMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class GuavaCacheFromContext {
    private GuavaCacheFromContext() {
    }

    public static <K, V> Cache<K, V> newGuavaCache(CacheContext context) {
        Ticker ticker;
        CacheBuilder builder;
        Preconditions.checkState((!context.isAsync() ? 1 : 0) != 0, (Object)"Guava caches are synchronous only");
        context.guava = builder = CacheBuilder.newBuilder();
        builder.concurrencyLevel(1);
        if (context.initialCapacity != CacheSpec.InitialCapacity.DEFAULT) {
            builder.initialCapacity(context.initialCapacity.size());
        }
        if (context.isRecordingStats()) {
            builder.recordStats();
        }
        if (context.maximumSize != CacheSpec.Maximum.DISABLED) {
            if (context.weigher == CacheSpec.CacheWeigher.DEFAULT) {
                builder.maximumSize(context.maximumSize.max());
            } else {
                builder.weigher(new GuavaWeigher<Object, Object>(context.weigher));
                builder.maximumWeight(context.maximumWeight());
            }
        }
        if (context.afterAccess != CacheSpec.Expire.DISABLED) {
            builder.expireAfterAccess(context.afterAccess.timeNanos(), TimeUnit.NANOSECONDS);
        }
        if (context.afterWrite != CacheSpec.Expire.DISABLED) {
            builder.expireAfterWrite(context.afterWrite.timeNanos(), TimeUnit.NANOSECONDS);
        }
        if (context.refresh != CacheSpec.Expire.DISABLED) {
            builder.refreshAfterWrite(context.refresh.timeNanos(), TimeUnit.NANOSECONDS);
        }
        if (context.expires() || context.refreshes()) {
            builder.ticker((Ticker)context.ticker());
        }
        if (context.keyStrength == CacheSpec.ReferenceType.WEAK) {
            builder.weakKeys();
        } else if (context.keyStrength == CacheSpec.ReferenceType.SOFT) {
            throw new IllegalStateException();
        }
        if (context.valueStrength == CacheSpec.ReferenceType.WEAK) {
            builder.weakValues();
        } else if (context.valueStrength == CacheSpec.ReferenceType.SOFT) {
            builder.softValues();
        }
        if (context.removalListenerType != CacheSpec.Listener.DEFAULT) {
            boolean translateZeroExpire = context.afterAccess == CacheSpec.Expire.IMMEDIATELY || context.afterWrite == CacheSpec.Expire.IMMEDIATELY;
            builder.removalListener(new GuavaRemovalListener<Integer, Integer>(translateZeroExpire, context.removalListener));
        }
        Object object = ticker = context.ticker == null ? Ticker.systemTicker() : context.ticker();
        context.cache = context.loader == null ? new GuavaCache(builder.build(), ticker, context.isRecordingStats()) : (context.loader().isBulk() ? new GuavaLoadingCache(builder.build(new BulkLoader<Integer, Integer>(context.loader())), ticker, context.isRecordingStats()) : new GuavaLoadingCache(builder.build(new SingleLoader<Integer, Integer>(context.loader())), ticker, context.isRecordingStats()));
        Cache<?, ?> castedCache = context.cache;
        return castedCache;
    }

    static final class CacheMissException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CacheMissException() {
        }
    }

    static class BulkLoader<K, V>
    extends SingleLoader<K, V> {
        private static final long serialVersionUID = 1L;

        BulkLoader(CacheLoader<K, V> delegate) {
            super(delegate);
        }

        public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
            return this.delegate.loadAll(keys);
        }
    }

    static class SingleLoader<K, V>
    extends com.google.common.cache.CacheLoader<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final CacheLoader<K, V> delegate;

        SingleLoader(CacheLoader<K, V> delegate) {
            this.delegate = delegate;
        }

        public V load(K key) throws Exception {
            Object value = this.delegate.load(key);
            if (value == null) {
                throw new CacheMissException();
            }
            return (V)value;
        }
    }

    static final class GuavaRemovalListener<K, V>
    implements com.google.common.cache.RemovalListener<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final RemovalListener<K, V> delegate;
        final boolean translateZeroExpire;

        GuavaRemovalListener(boolean translateZeroExpire, RemovalListener<K, V> delegate) {
            this.translateZeroExpire = translateZeroExpire;
            this.delegate = delegate;
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
            RemovalCause cause = RemovalCause.valueOf((String)notification.getCause().name());
            if (this.translateZeroExpire && cause == RemovalCause.SIZE) {
                cause = RemovalCause.EXPIRED;
            }
            this.delegate.onRemoval(notification.getKey(), notification.getValue(), cause);
        }
    }

    static final class GuavaWeigher<K, V>
    implements com.google.common.cache.Weigher<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Weigher<K, V> weigher;

        GuavaWeigher(Weigher<K, V> weigher) {
            this.weigher = weigher;
        }

        public int weigh(K key, V value) {
            return this.weigher.weigh(key, value);
        }
    }

    static class GuavaLoadingCache<K, V>
    extends GuavaCache<K, V>
    implements LoadingCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final com.google.common.cache.LoadingCache<K, V> cache;

        GuavaLoadingCache(com.google.common.cache.LoadingCache<K, V> cache, Ticker ticker, boolean isRecordingStats) {
            super(cache, ticker, isRecordingStats);
            this.cache = Objects.requireNonNull(cache);
        }

        public V get(K key) {
            try {
                return (V)this.cache.get(key);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CacheMissException) {
                    return null;
                }
                throw (RuntimeException)e.getCause();
            }
            catch (ExecutionException e) {
                throw new CompletionException(e);
            }
            catch (ExecutionError e) {
                throw (Error)e.getCause();
            }
        }

        public Map<K, V> getAll(Iterable<? extends K> keys) {
            try {
                return this.cache.getAll(keys);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CacheMissException) {
                    return ImmutableMap.of();
                }
                throw (RuntimeException)e.getCause();
            }
            catch (ExecutionException e) {
                throw new CompletionException(e);
            }
            catch (ExecutionError e) {
                throw (Error)e.getCause();
            }
        }

        public void refresh(K key) {
            this.cache.refresh(key);
        }
    }

    static class GuavaCache<K, V>
    implements Cache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final com.google.common.cache.Cache<K, V> cache;
        private final boolean isRecordingStats;
        private final Ticker ticker;
        transient AbstractCache.StatsCounter statsCounter = new AbstractCache.SimpleStatsCounter();

        GuavaCache(com.google.common.cache.Cache<K, V> cache, Ticker ticker, boolean isRecordingStats) {
            this.isRecordingStats = isRecordingStats;
            this.cache = Objects.requireNonNull(cache);
            this.ticker = ticker;
        }

        public V getIfPresent(Object key) {
            return (V)this.cache.getIfPresent(key);
        }

        public V get(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            try {
                return (V)this.cache.get(key, () -> {
                    Object value = mappingFunction.apply((Object)key);
                    if (value == null) {
                        throw new CacheMissException();
                    }
                    return value;
                });
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CacheMissException) {
                    return null;
                }
                throw (RuntimeException)e.getCause();
            }
            catch (ExecutionException e) {
                throw new CompletionException(e);
            }
            catch (ExecutionError e) {
                throw (Error)e.getCause();
            }
        }

        public Map<K, V> getAllPresent(Iterable<?> keys) {
            return this.cache.getAllPresent((Iterable)ImmutableSet.copyOf(keys));
        }

        public Map<K, V> getAll(Iterable<? extends K> keys, Function<Iterable<? extends K>, Map<K, V>> mappingFunction) {
            keys.forEach(Objects::requireNonNull);
            Objects.requireNonNull(mappingFunction);
            Map<K, V> found = this.getAllPresent(keys);
            Sets.SetView keysToLoad = Sets.difference((Set)ImmutableSet.copyOf(keys), found.keySet());
            if (keysToLoad.isEmpty()) {
                return found;
            }
            long start = this.ticker.read();
            try {
                Map<Object, Object> loaded = mappingFunction.apply((Iterable<K>)keysToLoad);
                loaded.forEach((arg_0, arg_1) -> this.cache.put(arg_0, arg_1));
                long end = this.ticker.read();
                this.statsCounter.recordLoadSuccess(end - start);
                LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
                for (K key : keys) {
                    V value = found.get(key);
                    if (value == null) {
                        value = loaded.get(key);
                    }
                    if (value == null) continue;
                    result.put(key, value);
                }
                return Collections.unmodifiableMap(result);
            }
            catch (Throwable t) {
                long end = this.ticker.read();
                this.statsCounter.recordLoadException(end - start);
                throw t;
            }
        }

        public void put(K key, V value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.cache.put(key, value);
        }

        public void putAll(Map<? extends K, ? extends V> map) {
            this.cache.putAll(map);
        }

        public void invalidate(Object key) {
            this.cache.invalidate(key);
        }

        public void invalidateAll(Iterable<?> keys) {
            keys.forEach(this::invalidate);
        }

        public void invalidateAll() {
            this.cache.invalidateAll();
        }

        public long estimatedSize() {
            return this.cache.size();
        }

        public com.github.benmanes.caffeine.cache.stats.CacheStats stats() {
            CacheStats stats = this.statsCounter.snapshot().plus(this.cache.stats());
            return new com.github.benmanes.caffeine.cache.stats.CacheStats(stats.hitCount(), stats.missCount(), stats.loadSuccessCount(), stats.loadExceptionCount(), stats.totalLoadTime(), stats.evictionCount(), 0L);
        }

        public ConcurrentMap<K, V> asMap() {
            return new ForwardingConcurrentMap<K, V>(){

                public boolean containsKey(Object key) {
                    Objects.requireNonNull(key);
                    return this.delegate().containsKey(key);
                }

                public boolean containsValue(Object value) {
                    Objects.requireNonNull(value);
                    return this.delegate().containsValue(value);
                }

                public V get(Object key) {
                    Objects.requireNonNull(key);
                    return this.delegate().get(key);
                }

                public V remove(Object key) {
                    Objects.requireNonNull(key);
                    return this.delegate().remove(key);
                }

                public boolean remove(Object key, Object value) {
                    Objects.requireNonNull(key);
                    return this.delegate().remove(key, value);
                }

                public boolean replace(K key, V oldValue, V newValue) {
                    Objects.requireNonNull(oldValue);
                    return this.delegate().replace(key, oldValue, newValue);
                }

                public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
                    Objects.requireNonNull(mappingFunction);
                    Object value = this.getIfPresent(key);
                    if (value != null) {
                        return value;
                    }
                    long now = ticker.read();
                    try {
                        value = mappingFunction.apply(key);
                        long loadTime = ticker.read() - now;
                        if (value == null) {
                            statsCounter.recordLoadException(loadTime);
                            return null;
                        }
                        statsCounter.recordLoadSuccess(loadTime);
                        Object v = this.delegate().putIfAbsent(key, value);
                        return v == null ? value : v;
                    }
                    catch (Error | RuntimeException e) {
                        statsCounter.recordLoadException(ticker.read() - now);
                        throw e;
                    }
                }

                public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
                    Objects.requireNonNull(remappingFunction);
                    long now = ticker.read();
                    Object oldValue = this.get(key);
                    if (oldValue != null) {
                        try {
                            Object newValue = remappingFunction.apply(key, oldValue);
                            long loadTime = ticker.read() - now;
                            if (newValue == null) {
                                statsCounter.recordLoadException(loadTime);
                                this.remove(key);
                                return null;
                            }
                            statsCounter.recordLoadSuccess(loadTime);
                            this.put(key, newValue);
                            return newValue;
                        }
                        catch (Error | RuntimeException e) {
                            statsCounter.recordLoadException(ticker.read() - now);
                            throw e;
                        }
                    }
                    return null;
                }

                public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
                    Objects.requireNonNull(remappingFunction);
                    Object oldValue = this.get(key);
                    long now = ticker.read();
                    try {
                        Object newValue = remappingFunction.apply(key, oldValue);
                        if (newValue == null) {
                            if (oldValue != null || this.containsKey(key)) {
                                this.remove(key);
                                statsCounter.recordLoadException(ticker.read() - now);
                                return null;
                            }
                            statsCounter.recordLoadException(ticker.read() - now);
                            return null;
                        }
                        statsCounter.recordLoadSuccess(ticker.read() - now);
                        this.put(key, newValue);
                        return newValue;
                    }
                    catch (Error | RuntimeException e) {
                        statsCounter.recordLoadException(ticker.read() - now);
                        throw e;
                    }
                }

                public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
                    Objects.requireNonNull(remappingFunction);
                    Objects.requireNonNull(value);
                    Object oldValue = this.get(key);
                    while (true) {
                        if (oldValue != null) {
                            long now = ticker.read();
                            try {
                                Object newValue = remappingFunction.apply(oldValue, value);
                                if (newValue != null) {
                                    if (this.replace(key, oldValue, newValue)) {
                                        statsCounter.recordLoadSuccess(ticker.read() - now);
                                        return newValue;
                                    }
                                } else if (this.remove(key, oldValue)) {
                                    statsCounter.recordLoadException(ticker.read() - now);
                                    return null;
                                }
                            }
                            catch (Error | RuntimeException e) {
                                statsCounter.recordLoadException(ticker.read() - now);
                                throw e;
                            }
                            oldValue = this.get(key);
                            continue;
                        }
                        oldValue = this.putIfAbsent(key, value);
                        if (oldValue == null) break;
                    }
                    return value;
                }

                protected ConcurrentMap<K, V> delegate() {
                    return cache.asMap();
                }

                private void readObject(ObjectInputStream stream) throws InvalidObjectException {
                    statsCounter = new AbstractCache.SimpleStatsCounter();
                }
            };
        }

        public void cleanUp() {
            this.cache.cleanUp();
        }

        public Policy<K, V> policy() {
            return new Policy<K, V>(){

                public boolean isRecordingStats() {
                    return isRecordingStats;
                }

                public Optional<Policy.Eviction<K, V>> eviction() {
                    return Optional.empty();
                }

                public Optional<Policy.Expiration<K, V>> expireAfterAccess() {
                    return Optional.empty();
                }

                public Optional<Policy.Expiration<K, V>> expireAfterWrite() {
                    return Optional.empty();
                }

                public Optional<Policy.Expiration<K, V>> refreshAfterWrite() {
                    return Optional.empty();
                }
            };
        }
    }
}

