/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.cache.testing.CacheSpec;
import com.github.benmanes.caffeine.cache.testing.RemovalNotification;
import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class HasRemovalNotifications<K, V>
extends TypeSafeDiagnosingMatcher<Object> {
    private final int count;
    private final RemovalCause cause;
    private final CacheContext context;

    public HasRemovalNotifications(CacheContext context, int count, @Nullable RemovalCause cause) {
        this.context = (CacheContext)Preconditions.checkNotNull((Object)context);
        this.cause = cause;
        this.count = count;
    }

    public void describeTo(Description description) {
        description.appendText("consumed");
    }

    protected boolean matchesSafely(Object ignored, Description description) {
        DescriptionBuilder desc = new DescriptionBuilder(description);
        if (this.context.removalListenerType == CacheSpec.Listener.CONSUMING) {
            List<RemovalNotification<Integer, Integer>> notifications = this.context.consumedNotifications();
            ForkJoinPool.commonPool().awaitQuiescence(10L, TimeUnit.SECONDS);
            int size = 0;
            for (RemovalNotification<Integer, Integer> notification : notifications) {
                if (notification.getCause() != this.cause) continue;
                this.checkNotification(notification);
                ++size;
            }
            desc.expectThat("notification count", Integer.valueOf(size), Matchers.is((Object)this.count));
        }
        return desc.matches();
    }

    private void checkNotification(RemovalNotification<?, ?> notification) {
        switch (notification.getCause()) {
            case EXPLICIT: 
            case REPLACED: {
                MatcherAssert.assertThat((Object)notification.wasEvicted(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat(notification.getKey(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
                MatcherAssert.assertThat(notification.getValue(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
                break;
            }
            case EXPIRED: 
            case SIZE: {
                MatcherAssert.assertThat((Object)notification.wasEvicted(), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat(notification.getKey(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
                MatcherAssert.assertThat(notification.getValue(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
                break;
            }
            case COLLECTED: {
                MatcherAssert.assertThat((Object)notification.wasEvicted(), (Matcher)Matchers.is((Object)true));
                if (this.context.isStrongKeys()) {
                    MatcherAssert.assertThat(notification.getKey(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
                }
                if (!this.context.isStrongValues()) break;
                MatcherAssert.assertThat(notification.getValue(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            }
        }
        if (this.cause != null) {
            MatcherAssert.assertThat((String)("Wrong removal cause for " + notification), (Object)notification.getCause(), (Matcher)Matchers.is((Object)this.cause));
        }
    }

    public static <K, V> HasRemovalNotifications<K, V> hasRemovalNotifications(CacheContext context, long count, RemovalCause cause) {
        return new HasRemovalNotifications<K, V>(context, (int)count, cause);
    }

    public static <K, V> HasRemovalNotifications<K, V> hasRemovalNotifications(CacheContext context, int count, RemovalCause cause) {
        return new HasRemovalNotifications<K, V>(context, count, cause);
    }
}

