/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.testing.CacheContext;
import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class HasStats
extends TypeSafeDiagnosingMatcher<CacheContext> {
    final long count;
    final StatsType type;
    DescriptionBuilder desc;

    private HasStats(StatsType type, long count) {
        this.count = count;
        this.type = type;
    }

    public void describeTo(Description description) {
        description.appendText("stats: " + this.type.name() + "=" + this.count);
        if (this.desc != null && description != this.desc.getDescription()) {
            description.appendText(this.desc.getDescription().toString());
        }
    }

    protected boolean matchesSafely(CacheContext context, Description description) {
        if (!context.isRecordingStats()) {
            return true;
        }
        CacheStats stats = context.stats();
        this.desc = new DescriptionBuilder(description);
        ForkJoinPool.commonPool().awaitQuiescence(10L, TimeUnit.SECONDS);
        switch (this.type) {
            case HIT: {
                return this.desc.expectThat(this.type.name(), Long.valueOf(stats.hitCount()), Matchers.is((Object)this.count)).matches();
            }
            case MISS: {
                return this.desc.expectThat(this.type.name(), Long.valueOf(stats.missCount()), Matchers.is((Object)this.count)).matches();
            }
            case EVICTION_COUNT: {
                return this.desc.expectThat(this.type.name(), Long.valueOf(stats.evictionCount()), Matchers.is((Object)this.count)).matches();
            }
            case EVICTION_WEIGHT: {
                return this.desc.expectThat(this.type.name(), Long.valueOf(stats.evictionWeight()), Matchers.is((Object)this.count)).matches();
            }
            case LOAD_SUCCESS: {
                return this.desc.expectThat(this.type.name(), Long.valueOf(stats.loadSuccessCount()), Matchers.is((Object)this.count)).matches();
            }
            case LOAD_FAILURE: {
                return this.desc.expectThat(this.type.name(), Long.valueOf(stats.loadFailureCount()), Matchers.is((Object)this.count)).matches();
            }
        }
        throw new AssertionError((Object)"Unknown stats type");
    }

    public static HasStats hasHitCount(long count) {
        return new HasStats(StatsType.HIT, count);
    }

    public static HasStats hasMissCount(long count) {
        return new HasStats(StatsType.MISS, count);
    }

    public static HasStats hasEvictionCount(long count) {
        return new HasStats(StatsType.EVICTION_COUNT, count);
    }

    public static HasStats hasEvictionWeight(long count) {
        return new HasStats(StatsType.EVICTION_WEIGHT, count);
    }

    public static HasStats hasLoadSuccessCount(long count) {
        return new HasStats(StatsType.LOAD_SUCCESS, count);
    }

    public static HasStats hasLoadFailureCount(long count) {
        return new HasStats(StatsType.LOAD_FAILURE, count);
    }

    private static enum StatsType {
        HIT,
        MISS,
        EVICTION_COUNT,
        EVICTION_WEIGHT,
        LOAD_SUCCESS,
        LOAD_FAILURE,
        TOTAL_LOAD_TIME;

    }
}

