/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.testing.RemovalNotification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;

public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> consuming() {
        return new ConsumingRemovalListener();
    }

    public static <K, V> RemovalListener<K, V> rejecting() {
        return new RejectingRemovalListener();
    }

    private static void validate(Object key, Object value, RemovalCause cause) {
        if (cause != RemovalCause.COLLECTED) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
        }
        Objects.requireNonNull(cause);
    }

    public static final class ConsumingRemovalListener<K, V>
    implements RemovalListener<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<RemovalNotification<K, V>> evicted = new ArrayList<RemovalNotification<K, V>>();

        public synchronized void onRemoval(K key, V value, RemovalCause cause) {
            RemovalListeners.validate(key, value, cause);
            this.evicted.add(new RemovalNotification<K, V>(key, value, cause));
        }

        public List<RemovalNotification<K, V>> evicted() {
            return this.evicted;
        }
    }

    public static final class RejectingRemovalListener<K, V>
    implements RemovalListener<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public boolean reject = true;
        public int rejected;

        public void onRemoval(K key, V value, RemovalCause cause) {
            RemovalListeners.validate(key, value, cause);
            if (this.reject) {
                ++this.rejected;
                throw new RejectedExecutionException("Rejected eviction of " + new RemovalNotification<K, V>(key, value, cause));
            }
        }
    }
}

