/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.google.errorprone.annotations.Immutable;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable(containerOf={"K", "V"})
public final class RemovalNotification<K, V>
implements Map.Entry<K, V> {
    private final @Nullable K key;
    private final @Nullable V value;
    private final RemovalCause cause;

    public RemovalNotification(@Nullable K key, @Nullable V value, @NonNull RemovalCause cause) {
        this.cause = Objects.requireNonNull(cause);
        this.value = value;
        this.key = key;
    }

    public @NonNull RemovalCause getCause() {
        return this.cause;
    }

    public boolean wasEvicted() {
        return this.cause.wasEvicted();
    }

    @Override
    public @Nullable K getKey() {
        return this.key;
    }

    @Override
    public @Nullable V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

