/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.testing;

import com.google.common.util.concurrent.ForwardingExecutorService;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public final class TrackingExecutor
extends ForwardingExecutorService {
    private final ExecutorService delegate;
    private final AtomicInteger failures;

    public TrackingExecutor(ExecutorService executor) {
        this.delegate = Objects.requireNonNull(executor);
        this.failures = new AtomicInteger();
    }

    public void execute(Runnable command) {
        try {
            this.delegate.execute(() -> {
                try {
                    command.run();
                }
                catch (Throwable t) {
                    this.failures.incrementAndGet();
                    throw t;
                }
            });
        }
        catch (Throwable t) {
            this.failures.incrementAndGet();
            throw t;
        }
    }

    public int failureCount() {
        return this.failures.get();
    }

    public ExecutorService delegate() {
        return this.delegate;
    }
}

