/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.testing;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ConcurrentTestHarness {
    private static final ThreadFactory DAEMON_FACTORY = new ThreadFactoryBuilder().setPriority(1).setDaemon(true).build();
    public static final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(DAEMON_FACTORY);
    public static final Executor executor = Executors.newCachedThreadPool(DAEMON_FACTORY);

    private ConcurrentTestHarness() {
    }

    public static void execute(Runnable task) {
        executor.execute(task);
    }

    public static long timeTasks(int nThreads, Runnable task) {
        return ConcurrentTestHarness.timeTasks(nThreads, Executors.callable(task)).executionTime();
    }

    public static <T> TestResult<T> timeTasks(int nThreads, Callable<T> task) {
        CountDownLatch startGate = new CountDownLatch(1);
        CountDownLatch endGate = new CountDownLatch(nThreads);
        AtomicReferenceArray results = new AtomicReferenceArray(nThreads);
        int i = 0;
        while (i < nThreads) {
            int index = i++;
            executor.execute(() -> {
                try {
                    startGate.await();
                    try {
                        results.set(index, task.call());
                    }
                    finally {
                        endGate.countDown();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        long start = System.nanoTime();
        startGate.countDown();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)endGate);
        long end = System.nanoTime();
        return new TestResult(end - start, ConcurrentTestHarness.toList(results));
    }

    private static <T> List<T> toList(AtomicReferenceArray<T> data) {
        ArrayList<T> list = new ArrayList<T>(data.length());
        for (int i = 0; i < data.length(); ++i) {
            list.add(data.get(i));
        }
        return list;
    }

    public static final class TestResult<T> {
        private final long executionTime;
        private final List<T> results;

        public TestResult(long executionTime, List<T> results) {
            this.executionTime = executionTime;
            this.results = results;
        }

        public long executionTime() {
            return this.executionTime;
        }

        public List<T> results() {
            return this.results;
        }
    }
}

