/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.testing;

import com.google.common.base.Throwables;
import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class DescriptionBuilder {
    private final Description description;
    private boolean matches;

    public DescriptionBuilder(Description description) {
        this.description = description instanceof Description.NullDescription ? new StringDescription() : description;
        this.matches = true;
    }

    public <T> DescriptionBuilder expectThat(Supplier<String> reason, T actual, Matcher<? super T> matcher) {
        if (!matcher.matches(actual)) {
            this.addError(reason.get(), actual, matcher);
        }
        return this;
    }

    public <T> DescriptionBuilder expectThat(String reason, T actual, Matcher<? super T> matcher) {
        if (!matcher.matches(actual)) {
            this.addError(reason, actual, matcher);
        }
        return this;
    }

    private <T> void addError(String reason, T actual, Matcher<? super T> matcher) {
        this.description.appendText(reason).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     but: ");
        matcher.describeMismatch(actual, this.description);
        this.description.appendText("\nLocation: ").appendText(Throwables.getStackTraceAsString((Throwable)new Exception()));
        this.matches = false;
    }

    public <T> DescriptionBuilder expected(String reason) {
        this.description.appendText(reason).appendText("\nExpected to not be reachable");
        this.description.appendText("\nLocation: ").appendText(Throwables.getStackTraceAsString((Throwable)new Exception()));
        this.matches = false;
        return this;
    }

    public Description getDescription() {
        return this.description;
    }

    public boolean matches() {
        return this.matches;
    }
}

