/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.testing;

import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsEmptyIterable<E>
extends TypeSafeDiagnosingMatcher<Iterable<? extends E>> {
    public void describeTo(Description description) {
        description.appendText("empty");
    }

    protected boolean matchesSafely(Iterable<? extends E> iterable, Description description) {
        DescriptionBuilder desc = new DescriptionBuilder(description);
        this.checkIterable(iterable, desc);
        if (iterable instanceof Collection) {
            this.checkCollection((Collection)iterable, desc);
        }
        if (iterable instanceof Set) {
            this.checkSet((Set)iterable, desc);
        }
        if (iterable instanceof List) {
            this.checkList((List)iterable, desc);
        }
        if (iterable instanceof Queue) {
            this.checkQueue((Queue)iterable, desc);
        }
        if (iterable instanceof Deque) {
            this.checkDeque((Deque)iterable, desc);
        }
        return desc.matches();
    }

    private void checkIterable(Iterable<? extends E> i, DescriptionBuilder builder) {
        builder.expectThat("iterator has data", Boolean.valueOf(i.iterator().hasNext()), Matchers.is((Object)false));
    }

    private void checkCollection(Collection<? extends E> c, DescriptionBuilder builder) {
        builder.expectThat("empty collection", c, Matchers.hasSize((int)0));
        builder.expectThat("not empty", Boolean.valueOf(c.isEmpty()), Matchers.is((Object)true));
        builder.expectThat("toArray has data", c.toArray(), Matchers.is((Matcher)Matchers.arrayWithSize((int)0)));
        builder.expectThat("toArray has data", c.toArray(new Object[0]), Matchers.is((Matcher)Matchers.arrayWithSize((int)0)));
    }

    private void checkSet(Set<? extends E> set, DescriptionBuilder builder) {
        builder.expectThat("hashcode", Integer.valueOf(set.hashCode()), Matchers.is((Matcher)Matchers.equalTo((Object)Collections.emptySet().hashCode())));
        builder.expectThat("collection not equal to empty set", set, Matchers.is(Collections.emptySet()));
        builder.expectThat("empty set not equal to collection", Collections.emptySet(), Matchers.is(set));
    }

    private void checkList(List<? extends E> list, DescriptionBuilder builder) {
        builder.expectThat("hashcode", Integer.valueOf(list.hashCode()), Matchers.is((Matcher)Matchers.equalTo((Object)Collections.emptyList().hashCode())));
        builder.expectThat("collection not equal to empty list", list, Matchers.is(Collections.emptyList()));
        builder.expectThat("empty list not equal to collection", Collections.emptyList(), Matchers.is(list));
    }

    private void checkQueue(Queue<? extends E> queue, DescriptionBuilder builder) {
        builder.expectThat("empty queue", queue.peek(), Matchers.is((Matcher)Matchers.nullValue()));
        this.checkNoSuchElementException("remove", builder, queue::remove);
        this.checkNoSuchElementException("element", builder, queue::element);
    }

    private void checkDeque(Deque<? extends E> deque, DescriptionBuilder builder) {
        builder.expectThat("empty deque", deque.peekFirst(), Matchers.is((Matcher)Matchers.nullValue()));
        builder.expectThat("empty deque", deque.peekLast(), Matchers.is((Matcher)Matchers.nullValue()));
        builder.expectThat("empty deque", Boolean.valueOf(deque.descendingIterator().hasNext()), Matchers.is((Object)false));
    }

    private void checkNoSuchElementException(String label, DescriptionBuilder builder, Runnable method) {
        try {
            method.run();
            builder.expected(label);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static <E> IsEmptyIterable<E> deeplyEmpty() {
        return new IsEmptyIterable<E>();
    }
}

