/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.testing;

import com.github.benmanes.caffeine.testing.DescriptionBuilder;
import com.github.benmanes.caffeine.testing.IsEmptyIterable;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsEmptyMap<K, V>
extends TypeSafeDiagnosingMatcher<Map<? extends K, ? extends V>> {
    public void describeTo(Description description) {
        description.appendText("emptyMap");
    }

    protected boolean matchesSafely(Map<? extends K, ? extends V> map, Description description) {
        DescriptionBuilder desc = new DescriptionBuilder(description);
        desc.expectThat("empty keyset", map.keySet(), Matchers.is(IsEmptyIterable.deeplyEmpty()));
        desc.expectThat("empty values", map.values(), Matchers.is(IsEmptyIterable.deeplyEmpty()));
        desc.expectThat("empty entrySet", map.entrySet(), Matchers.is(IsEmptyIterable.deeplyEmpty()));
        desc.expectThat("empty map", map, Matchers.is((Object)Collections.EMPTY_MAP));
        desc.expectThat("Size != 0", Integer.valueOf(map.size()), Matchers.is((Object)0));
        desc.expectThat("Not empty", Boolean.valueOf(map.isEmpty()), Matchers.is((Object)true));
        desc.expectThat("hashcode", Integer.valueOf(map.hashCode()), Matchers.is((Object)ImmutableMap.of().hashCode()));
        desc.expectThat("toString", map, Matchers.hasToString((String)ImmutableMap.of().toString()));
        return desc.matches();
    }

    public static <K, V> IsEmptyMap<K, V> emptyMap() {
        return new IsEmptyMap<K, V>();
    }
}

