/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.testing;

import com.github.benmanes.caffeine.testing.ConcurrentTestHarness;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.log4testng.Logger;

public final class Threads {
    private static final Logger logger = Logger.getLogger(Threads.class);
    public static final int ITERATIONS = 40000;
    public static final int NTHREADS = 20;
    public static final int TIMEOUT = 30;

    private Threads() {
    }

    public static <A> void runTest(A collection, List<BiConsumer<A, Integer>> operations) {
        ConcurrentLinkedQueue<String> failures = new ConcurrentLinkedQueue<String>();
        Thrasher thrasher = new Thrasher(collection, failures, operations);
        Threads.executeWithTimeOut(failures, () -> ConcurrentTestHarness.timeTasks(20, thrasher));
        MatcherAssert.assertThat(failures, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    public static void executeWithTimeOut(Queue<String> failures, Callable<Long> task) {
        ExecutorService es = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
        Future<Long> future = es.submit(task);
        try {
            long timeNS = future.get(30L, TimeUnit.SECONDS);
            logger.debug((Object)("\nExecuted in " + TimeUnit.NANOSECONDS.toSeconds(timeNS) + " second(s)"));
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Exception during test: " + e.toString()), (Throwable)e);
        }
        catch (TimeoutException e) {
            Threads.handleTimout(failures, es, e);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"", (Throwable)e);
        }
    }

    public static void handleTimout(Queue<String> failures, ExecutorService es, TimeoutException e) {
        for (StackTraceElement[] trace : Thread.getAllStackTraces().values()) {
            for (StackTraceElement element : trace) {
                logger.info((Object)("\tat " + element));
            }
            if (trace.length <= 0) continue;
            logger.info((Object)"------");
        }
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)es, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        for (String failure : failures) {
            logger.debug((Object)failure);
        }
        Assert.fail((String)"Spun forever", (Throwable)e);
    }

    public static List<List<Integer>> workingSets(int nThreads, int iterations) {
        List keys = IntStream.range(0, iterations).boxed().map(i -> ThreadLocalRandom.current().nextInt(iterations / 100)).collect(Collectors.toList());
        return Threads.shuffle(nThreads, keys);
    }

    private static <T> List<List<T>> shuffle(int samples, Collection<T> baseline) {
        ArrayList<ImmutableList> workingSets = new ArrayList<ImmutableList>(samples);
        for (int i = 0; i < samples; ++i) {
            ArrayList<T> workingSet = new ArrayList<T>(baseline);
            Collections.shuffle(workingSet);
            workingSets.add(ImmutableList.copyOf(workingSet));
        }
        return ImmutableList.copyOf(workingSets);
    }

    public static final class Thrasher<A>
    implements Runnable {
        private final List<BiConsumer<A, Integer>> operations;
        private final List<List<Integer>> sets = Threads.workingSets(20, 40000);
        private final Queue<String> failures;
        private final AtomicInteger index = new AtomicInteger();
        private final A collection;

        public Thrasher(A collection, Queue<String> failures, List<BiConsumer<A, Integer>> operations) {
            this.operations = operations;
            this.collection = collection;
            this.failures = failures;
        }

        @Override
        public void run() {
            int id = this.index.getAndIncrement();
            for (Integer e : this.sets.get(id)) {
                BiConsumer<A, Integer> operation = this.operations.get(ThreadLocalRandom.current().nextInt(this.operations.size()));
                try {
                    operation.accept(this.collection, e);
                }
                catch (Throwable t) {
                    this.failures.add(String.format("Failed: key %s on operation %s%n%s", e, operation, Throwables.getStackTraceAsString((Throwable)t)));
                    throw t;
                }
            }
        }
    }
}

