/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.configuration;

import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.jcache.copy.Copier;
import com.github.benmanes.caffeine.jcache.copy.JavaSerializationCopier;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CaffeineConfiguration<K, V>
implements CompleteConfiguration<K, V> {
    private static final Factory<Copier> JAVA_COPIER = JavaSerializationCopier::new;
    private static final Factory<Executor> COMMON_POOL = ForkJoinPool::commonPool;
    private static final Factory<Ticker> SYSTEM_TICKER = Ticker::systemTicker;
    private static final long serialVersionUID = 1L;
    private final MutableConfiguration<K, V> delegate;
    private @Nullable Factory<Weigher<K, V>> weigherFactory;
    private @Nullable Factory<Expiry<K, V>> expiryFactory;
    private Factory<Executor> executorFactory;
    private Factory<Copier> copierFactory;
    private Factory<Ticker> tickerFactory;
    private @Nullable Long refreshAfterWriteNanos;
    private @Nullable Long expireAfterAccessNanos;
    private @Nullable Long expireAfterWriteNanos;
    private @Nullable Long maximumWeight;
    private @Nullable Long maximumSize;

    public CaffeineConfiguration() {
        this.delegate = new MutableConfiguration();
        this.delegate.setStoreByValue(false);
        this.tickerFactory = SYSTEM_TICKER;
        this.executorFactory = COMMON_POOL;
        this.copierFactory = JAVA_COPIER;
    }

    public CaffeineConfiguration(CompleteConfiguration<K, V> configuration) {
        this.delegate = new MutableConfiguration(configuration);
        if (configuration instanceof CaffeineConfiguration) {
            CaffeineConfiguration config = (CaffeineConfiguration)configuration;
            this.refreshAfterWriteNanos = config.refreshAfterWriteNanos;
            this.expireAfterAccessNanos = config.expireAfterAccessNanos;
            this.expireAfterWriteNanos = config.expireAfterWriteNanos;
            this.executorFactory = config.executorFactory;
            this.expiryFactory = config.expiryFactory;
            this.copierFactory = config.copierFactory;
            this.tickerFactory = config.tickerFactory;
            this.weigherFactory = config.weigherFactory;
            this.maximumWeight = config.maximumWeight;
            this.maximumSize = config.maximumSize;
        } else {
            this.tickerFactory = SYSTEM_TICKER;
            this.executorFactory = COMMON_POOL;
            this.copierFactory = JAVA_COPIER;
        }
    }

    public Class<K> getKeyType() {
        return this.delegate.getKeyType();
    }

    public Class<V> getValueType() {
        return this.delegate.getValueType();
    }

    public void setTypes(Class<K> keyType, Class<V> valueType) {
        this.delegate.setTypes(keyType, valueType);
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return this.delegate.getCacheEntryListenerConfigurations();
    }

    public void addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.delegate.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public void removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.delegate.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.delegate.getCacheLoaderFactory();
    }

    public void setCacheLoaderFactory(Factory<? extends CacheLoader<K, V>> factory) {
        this.delegate.setCacheLoaderFactory(factory);
    }

    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.delegate.getCacheWriterFactory();
    }

    public @Nullable CacheWriter<K, V> getCacheWriter() {
        if (this.hasCacheWriter()) {
            CacheWriter writer = (CacheWriter)this.getCacheWriterFactory().create();
            return writer;
        }
        return null;
    }

    public boolean hasCacheWriter() {
        return this.getCacheWriterFactory() != null;
    }

    public void setCacheWriterFactory(Factory<? extends CacheWriter<? super K, ? super V>> factory) {
        this.delegate.setCacheWriterFactory(factory);
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.delegate.getExpiryPolicyFactory();
    }

    public void setExpiryPolicyFactory(Factory<? extends ExpiryPolicy> factory) {
        this.delegate.setExpiryPolicyFactory(factory);
    }

    public boolean isReadThrough() {
        return this.delegate.isReadThrough();
    }

    public void setReadThrough(boolean isReadThrough) {
        this.delegate.setReadThrough(isReadThrough);
    }

    public boolean isWriteThrough() {
        return this.delegate.isWriteThrough();
    }

    public void setWriteThrough(boolean isWriteThrough) {
        this.delegate.setWriteThrough(isWriteThrough);
    }

    public boolean isStoreByValue() {
        return this.delegate.isStoreByValue();
    }

    public void setStoreByValue(boolean isStoreByValue) {
        this.delegate.setStoreByValue(isStoreByValue);
    }

    public boolean isStatisticsEnabled() {
        return this.delegate.isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.delegate.setStatisticsEnabled(enabled);
    }

    public boolean isManagementEnabled() {
        return this.delegate.isManagementEnabled();
    }

    public void setManagementEnabled(boolean enabled) {
        this.delegate.setManagementEnabled(enabled);
    }

    public Factory<Copier> getCopierFactory() {
        return this.copierFactory;
    }

    public void setCopierFactory(Factory<Copier> factory) {
        this.copierFactory = Objects.requireNonNull(factory);
    }

    public Factory<Ticker> getTickerFactory() {
        return this.tickerFactory;
    }

    public void setTickerFactory(Factory<Ticker> factory) {
        this.tickerFactory = Objects.requireNonNull(factory);
    }

    public Factory<Executor> getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(Factory<Executor> factory) {
        this.executorFactory = Objects.requireNonNull(factory);
    }

    public OptionalLong getRefreshAfterWrite() {
        return this.refreshAfterWriteNanos == null ? OptionalLong.empty() : OptionalLong.of(this.refreshAfterWriteNanos);
    }

    public void setRefreshAfterWrite(OptionalLong refreshAfterWriteNanos) {
        this.refreshAfterWriteNanos = refreshAfterWriteNanos.isPresent() ? Long.valueOf(refreshAfterWriteNanos.getAsLong()) : null;
    }

    public OptionalLong getExpireAfterWrite() {
        return this.expireAfterWriteNanos == null ? OptionalLong.empty() : OptionalLong.of(this.expireAfterWriteNanos);
    }

    public void setExpireAfterWrite(OptionalLong expireAfterWriteNanos) {
        this.expireAfterWriteNanos = expireAfterWriteNanos.isPresent() ? Long.valueOf(expireAfterWriteNanos.getAsLong()) : null;
    }

    public OptionalLong getExpireAfterAccess() {
        return this.expireAfterAccessNanos == null ? OptionalLong.empty() : OptionalLong.of(this.expireAfterAccessNanos);
    }

    public void setExpireAfterAccess(OptionalLong expireAfterAccessNanos) {
        this.expireAfterAccessNanos = expireAfterAccessNanos.isPresent() ? Long.valueOf(expireAfterAccessNanos.getAsLong()) : null;
    }

    public Optional<Factory<Expiry<K, V>>> getExpiryFactory() {
        return Optional.ofNullable(this.expiryFactory);
    }

    public void setExpiryFactory(Optional<Factory<? extends Expiry<K, V>>> factory) {
        this.expiryFactory = factory.orElse(null);
    }

    public void setMaximumSize(OptionalLong maximumSize) {
        this.maximumSize = maximumSize.isPresent() ? Long.valueOf(maximumSize.getAsLong()) : null;
    }

    public OptionalLong getMaximumSize() {
        return this.maximumSize == null ? OptionalLong.empty() : OptionalLong.of(this.maximumSize);
    }

    public void setMaximumWeight(OptionalLong maximumWeight) {
        this.maximumWeight = maximumWeight.isPresent() ? Long.valueOf(maximumWeight.getAsLong()) : null;
    }

    public OptionalLong getMaximumWeight() {
        return this.maximumWeight == null ? OptionalLong.empty() : OptionalLong.of(this.maximumWeight);
    }

    public Optional<Factory<Weigher<K, V>>> getWeigherFactory() {
        return Optional.ofNullable(this.weigherFactory);
    }

    public void setWeigherFactory(Optional<Factory<? extends Weigher<K, V>>> factory) {
        this.weigherFactory = factory.orElse(null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaffeineConfiguration)) {
            return false;
        }
        CaffeineConfiguration config = (CaffeineConfiguration)o;
        return Objects.equals(this.refreshAfterWriteNanos, config.refreshAfterWriteNanos) && Objects.equals(this.expireAfterAccessNanos, config.expireAfterAccessNanos) && Objects.equals(this.expireAfterWriteNanos, config.expireAfterWriteNanos) && Objects.equals(this.executorFactory, config.executorFactory) && Objects.equals(this.copierFactory, config.copierFactory) && Objects.equals(this.tickerFactory, config.tickerFactory) && Objects.equals(this.weigherFactory, config.weigherFactory) && Objects.equals(this.maximumWeight, config.maximumWeight) && Objects.equals(this.maximumSize, config.maximumSize) && this.delegate.equals(config.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

