/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.spi;

import com.github.benmanes.caffeine.jcache.CacheManagerImpl;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CaffeineCachingProvider
implements CachingProvider {
    private static final ClassLoader DEFAULT_CLASS_LOADER = AccessController.doPrivileged(() -> new JCacheClassLoader());
    @GuardedBy(value="itself")
    private final Map<ClassLoader, Map<URI, CacheManager>> cacheManagers = new WeakHashMap<ClassLoader, Map<URI, CacheManager>>(1);

    public ClassLoader getDefaultClassLoader() {
        return DEFAULT_CLASS_LOADER;
    }

    public URI getDefaultURI() {
        return URI.create(this.getClass().getName());
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        URI managerURI = this.getManagerUri(uri);
        ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Map cacheManagersByURI = this.cacheManagers.computeIfAbsent(managerClassLoader, any -> new HashMap());
            return cacheManagersByURI.computeIfAbsent(managerURI, any -> {
                Properties managerProperties = properties == null ? this.getDefaultProperties() : properties;
                return new CacheManagerImpl(this, managerURI, managerClassLoader, managerProperties);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (ClassLoader classLoader : new ArrayList<ClassLoader>(this.cacheManagers.keySet())) {
                this.close(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
            Map<URI, CacheManager> cacheManagersByURI = this.cacheManagers.remove(managerClassLoader);
            if (cacheManagersByURI != null) {
                for (CacheManager cacheManager : cacheManagersByURI.values()) {
                    cacheManager.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
            Map<URI, CacheManager> cacheManagersByURI = this.cacheManagers.get(managerClassLoader);
            if (cacheManagersByURI != null) {
                CacheManager cacheManager = cacheManagersByURI.remove(this.getManagerUri(uri));
                if (cacheManager != null) {
                    cacheManager.close();
                }
                if (cacheManagersByURI.isEmpty()) {
                    this.cacheManagers.remove(managerClassLoader);
                }
            }
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return optionalFeature == OptionalFeature.STORE_BY_REFERENCE;
    }

    private URI getManagerUri(URI uri) {
        return uri == null ? this.getDefaultURI() : uri;
    }

    private ClassLoader getManagerClassLoader(ClassLoader classLoader) {
        return classLoader == null ? this.getDefaultClassLoader() : classLoader;
    }

    private static final class JCacheClassLoader
    extends ClassLoader {
        private JCacheClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            ClassLoader classClassLoader;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            ClassNotFoundException error = null;
            if (contextClassLoader != null) {
                try {
                    return contextClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    error = e;
                }
            }
            if ((classClassLoader = this.getClass().getClassLoader()) != null && classClassLoader != contextClassLoader) {
                return classClassLoader.loadClass(name);
            }
            throw error == null ? new ClassNotFoundException(name) : error;
        }

        @Override
        public @Nullable URL getResource(String name) {
            URL resource;
            URL resource2;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null && (resource2 = contextClassLoader.getResource(name)) != null) {
                return resource2;
            }
            ClassLoader classClassLoader = Thread.currentThread().getContextClassLoader();
            if (classClassLoader != null && classClassLoader != contextClassLoader && (resource = classClassLoader.getResource(name)) != null) {
                return resource;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ClassLoader classClassLoader;
            ArrayList<URL> resources = new ArrayList<URL>();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                resources.addAll(Collections.list(contextClassLoader.getResources(name)));
            }
            if ((classClassLoader = Thread.currentThread().getContextClassLoader()) != null && classClassLoader != contextClassLoader) {
                resources.addAll(Collections.list(classClassLoader.getResources(name)));
            }
            return Collections.enumeration(resources);
        }
    }
}

