/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import java.util.Locale;
import java.util.Objects;

public final class Expirable<V> {
    private final V value;
    private volatile long expireTimeMillis;

    public Expirable(V value, long expireTimeMillis) {
        this.value = Objects.requireNonNull(value);
        this.expireTimeMillis = expireTimeMillis;
    }

    public V get() {
        return this.value;
    }

    public long getExpireTimeMillis() {
        return this.expireTimeMillis;
    }

    public void setExpireTimeMillis(long expireTimeMillis) {
        this.expireTimeMillis = expireTimeMillis;
    }

    public boolean hasExpired(long currentTimeMillis) {
        return currentTimeMillis - this.expireTimeMillis >= 0L;
    }

    public boolean isEternal() {
        return this.expireTimeMillis == Long.MAX_VALUE;
    }

    public String toString() {
        return String.format(Locale.US, "%s{value=%s, expireTimeMillis=%,d}", this.getClass().getSimpleName(), this.value, this.expireTimeMillis);
    }
}

