/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.frequency;

import com.clearspring.analytics.stream.frequency.ConservativeAddSketch;
import com.clearspring.analytics.stream.frequency.CountMinSketch;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.typesafe.config.Config;

public final class CountMin64TinyLfu
implements Frequency {
    private static final int MAX_COUNT = 15;
    final CountMinSketch sketch;
    final int sampleSize;
    int size;

    public CountMin64TinyLfu(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.sampleSize = 10 * settings.maximumSize();
        this.sketch = settings.tinyLfu().conservative() ? new ConservativeAddSketch(settings.tinyLfu().countMin64().eps(), settings.tinyLfu().countMin64().confidence(), settings.randomSeed()) : new CountMinSketch(settings.tinyLfu().countMin64().eps(), settings.tinyLfu().countMin64().confidence(), settings.randomSeed());
    }

    @Override
    public int frequency(long o) {
        return (int)this.sketch.estimateCount(o);
    }

    @Override
    public void increment(long o) {
        if (this.sketch.estimateCount(o) < 15L) {
            this.sketch.add(o, 1L);
        }
        ++this.size;
        this.resetIfNeeded();
    }

    private void resetIfNeeded() {
        if (this.size > this.sampleSize) {
            this.size /= 2;
            for (int i = 0; i < this.sketch.depth; ++i) {
                int j = 0;
                while (j < this.sketch.width) {
                    this.size = (int)((long)this.size - (this.sketch.table[i][j] & 1L));
                    long[] lArray = this.sketch.table[i];
                    int n = j++;
                    lArray[n] = lArray[n] >>> 1;
                }
            }
        }
    }
}

