/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import akka.Main;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.routing.ActorRefRoutee;
import akka.routing.BroadcastRoutingLogic;
import akka.routing.Routee;
import akka.routing.Router;
import akka.routing.RoutingLogic;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.Synthetic;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyActor;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.Registry;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.base.Stopwatch;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

public final class Simulator
extends UntypedActor {
    private final BasicSettings settings;
    private final Stopwatch stopwatch;
    private final Reporter report;
    private final Router router;
    private final int batchSize;
    private int remaining;

    public Simulator() {
        Config config = this.getContext().system().settings().config().getConfig("caffeine.simulator");
        this.settings = new BasicSettings(config);
        List<Routee> routes = this.makeRoutes();
        this.router = new Router((RoutingLogic)new BroadcastRoutingLogic(), routes);
        this.remaining = routes.size();
        this.batchSize = this.settings.batchSize();
        this.stopwatch = Stopwatch.createStarted();
        this.report = this.settings.report().format().create(config);
        this.getSelf().tell((Object)Message.START, ActorRef.noSender());
    }

    public void onReceive(Object msg) throws IOException {
        if (msg == Message.START) {
            this.broadcast();
        } else if (msg == Message.ERROR) {
            this.getContext().stop(this.getSelf());
        } else if (msg instanceof PolicyStats) {
            this.report.add((PolicyStats)msg);
            if (--this.remaining == 0) {
                this.report.print();
                this.getContext().stop(this.getSelf());
                System.out.println("Executed in " + this.stopwatch);
            }
        }
    }

    private void broadcast() throws IOException {
        try (LongStream events = this.eventStream();){
            LongArrayList batch = new LongArrayList(this.batchSize);
            PrimitiveIterator.OfLong i = events.iterator();
            while (i.hasNext()) {
                batch.add(i.nextLong());
                if (batch.size() != this.batchSize) continue;
                this.router.route((Object)batch, this.getSelf());
                batch = new LongArrayList(this.batchSize);
            }
            this.router.route((Object)batch, this.getSelf());
            this.router.route((Object)Message.FINISH, this.getSelf());
        }
        catch (Exception e) {
            this.router.route((Object)Message.ERROR, this.getSelf());
            this.context().system().log().error((Throwable)e, "");
            this.getContext().stop(this.getSelf());
        }
    }

    private LongStream eventStream() throws IOException {
        if (this.settings.isSynthetic()) {
            return Synthetic.generate(this.settings);
        }
        List<String> filePaths = this.settings.traceFiles().paths();
        TraceFormat format = this.settings.traceFiles().format();
        return format.readFiles(filePaths).events();
    }

    private List<Routee> makeRoutes() {
        return Registry.policies(this.settings).stream().map(policy -> {
            ActorRef actorRef = this.getContext().actorOf(Props.create(PolicyActor.class, (Object[])new Object[]{policy}));
            this.getContext().watch(actorRef);
            return new ActorRefRoutee(actorRef);
        }).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        Main.main((String[])new String[]{Simulator.class.getName()});
    }

    public static enum Message {
        START,
        FINISH,
        ERROR;

    }
}

