/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.yahoo.ycsb.generator.CounterGenerator;
import com.yahoo.ycsb.generator.ExponentialGenerator;
import com.yahoo.ycsb.generator.HotspotIntegerGenerator;
import com.yahoo.ycsb.generator.NumberGenerator;
import com.yahoo.ycsb.generator.ScrambledZipfianGenerator;
import com.yahoo.ycsb.generator.SkewedLatestGenerator;
import com.yahoo.ycsb.generator.UniformIntegerGenerator;
import com.yahoo.ycsb.generator.ZipfianGenerator;
import java.util.stream.LongStream;

public final class Synthetic {
    private Synthetic() {
    }

    public static LongStream generate(BasicSettings settings) {
        int events = settings.synthetic().events();
        switch (settings.synthetic().distribution().toLowerCase()) {
            case "counter": {
                return Synthetic.counter(settings.synthetic().counter().start(), events);
            }
            case "exponential": {
                return Synthetic.exponential(settings.synthetic().exponential().mean(), events);
            }
            case "hotspot": {
                BasicSettings.SyntheticSettings.HotspotSettings hotspot = settings.synthetic().hotspot();
                return Synthetic.hotspot(hotspot.lowerBound(), hotspot.upperBound(), hotspot.hotOpnFraction(), hotspot.hotsetFraction(), events);
            }
            case "zipfian": {
                return Synthetic.zipfian(settings.synthetic().zipfian().items(), events);
            }
            case "scrambled-zipfian": {
                return Synthetic.scrambledZipfian(settings.synthetic().zipfian().items(), events);
            }
            case "skewed-zipfian-latest": {
                return Synthetic.skewedZipfianLatest(settings.synthetic().zipfian().items(), events);
            }
            case "uniform": {
                BasicSettings.SyntheticSettings.UniformSettings uniform = settings.synthetic().uniform();
                return Synthetic.uniform(uniform.lowerBound(), uniform.upperBound(), events);
            }
        }
        throw new IllegalStateException("Unknown distribution: " + settings.synthetic().distribution());
    }

    public static LongStream counter(int start, int events) {
        return Synthetic.generate((NumberGenerator)new CounterGenerator(start), events);
    }

    public static LongStream exponential(double mean, int events) {
        return Synthetic.generate((NumberGenerator)new ExponentialGenerator(mean), events);
    }

    public static LongStream hotspot(int lowerBound, int upperBound, double hotsetFraction, double hotOpnFraction, int events) {
        return Synthetic.generate((NumberGenerator)new HotspotIntegerGenerator(lowerBound, upperBound, hotsetFraction, hotOpnFraction), events);
    }

    public static LongStream scrambledZipfian(int items, int events) {
        return Synthetic.generate((NumberGenerator)new ScrambledZipfianGenerator((long)items), events);
    }

    public static LongStream skewedZipfianLatest(int items, int events) {
        return Synthetic.generate((NumberGenerator)new SkewedLatestGenerator(new CounterGenerator(items)), events);
    }

    public static LongStream zipfian(int items, int events) {
        return Synthetic.generate((NumberGenerator)new ZipfianGenerator((long)items), events);
    }

    public static LongStream uniform(int lowerBound, int upperBound, int events) {
        return Synthetic.generate((NumberGenerator)new UniformIntegerGenerator(lowerBound, upperBound), events);
    }

    private static LongStream generate(NumberGenerator generator, long count) {
        return LongStream.range(0L, count).map(ignored -> ((Number)generator.nextValue()).intValue());
    }
}

