/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission;

import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.typesafe.config.Config;
import java.util.function.Function;

public enum Admission {
    ALWAYS(config -> Admittor.always(), Function.identity()),
    TINYLFU(TinyLfu::new, name -> name + "_TinyLfu");

    private final Function<Config, Admittor> factory;
    private final Function<String, String> formatter;

    private Admission(Function<Config, Admittor> factory, Function<String, String> formatter) {
        this.formatter = formatter;
        this.factory = factory;
    }

    public Admittor from(Config config) {
        return this.factory.apply(config);
    }

    public String format(String name) {
        return this.formatter.apply(name);
    }
}

