/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheSketch;
import com.typesafe.config.Config;

public final class TinyCacheAdapter
implements Frequency {
    TinyCacheSketch tcs;
    int nrSets;
    static final int sampleFactor = 10;
    static final int maxcount = 10;

    public TinyCacheAdapter(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.nrSets = 10 * settings.maximumSize() / 64;
        this.tcs = new TinyCacheSketch(this.nrSets, 64, settings.randomSeed());
    }

    @Override
    public int frequency(long e) {
        return this.tcs.countItem(e);
    }

    @Override
    public void increment(long e) {
        if (this.tcs.countItem(e) < 10) {
            this.tcs.addItem(e);
        }
    }
}

