/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public abstract class TextTraceReader
implements TraceReader {
    private final List<String> filePaths;

    public TextTraceReader(List<String> filePaths) {
        this.filePaths = Objects.requireNonNull(filePaths);
    }

    protected Stream<String> lines() throws IOException {
        InputStream input = this.readFiles();
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        return (Stream)new BufferedReader(reader, 65536).lines().map(String::trim).onClose(() -> Closeables.closeQuietly((InputStream)input));
    }

    private InputStream readFiles() throws IOException {
        ArrayList<InputStream> inputs = new ArrayList<InputStream>(this.filePaths.size());
        for (String filePath : this.filePaths) {
            inputs.add(this.readFile(filePath));
        }
        return new SequenceInputStream(Collections.enumeration(inputs));
    }

    private InputStream readFile(String filePath) throws IOException {
        BufferedInputStream input = new BufferedInputStream(this.openFile(filePath));
        input.mark(100);
        try {
            return new CompressorStreamFactory().createCompressorInputStream((InputStream)input);
        }
        catch (CompressorException e) {
            input.reset();
            try {
                return new ArchiveStreamFactory().createArchiveInputStream((InputStream)input);
            }
            catch (ArchiveException e2) {
                input.reset();
                return input;
            }
        }
    }

    private InputStream openFile(String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        InputStream input = this.getClass().getResourceAsStream(filePath);
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)("Could not find file: " + filePath));
        return input;
    }
}

