/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.address.AddressTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.arc.ArcTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.lirs.LirsTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.umass.storage.StorageTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.wikipedia.WikipediaTraceReader;
import java.util.List;
import java.util.function.Function;

public enum TraceFormat {
    ADDRESS(AddressTraceReader::new),
    ARC(ArcTraceReader::new),
    LIRS(LirsTraceReader::new),
    UMASS_STORAGE(StorageTraceReader::new),
    WIKIPEDIA(WikipediaTraceReader::new);

    private final Function<List<String>, TraceReader> factory;

    private TraceFormat(Function<List<String>, TraceReader> factory) {
        this.factory = factory;
    }

    public TraceReader readFiles(List<String> filePaths) {
        return this.factory.apply(filePaths);
    }
}

