/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.wikipedia;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class WikipediaTraceReader
extends TextTraceReader {
    private static final String[] CONTAINS_FILTER = new String[]{"?search=", "&search=", "User+talk", "User_talk", "User:", "Talk:", "&diff=", "&action=rollback", "Special:Watchlist"};
    private static final String[] STARTS_WITH_FILTER = new String[]{"wiki/Special:Search", "w/query.php", "wiki/Talk:", "wiki/Special:AutoLogin", "Special:UserLogin", "w/api.php", "error:"};
    private static final String[] SEARCH_LIST = new String[]{"%2F", "%20", "&amp;", "%3A"};
    private static final String[] REPLACEMENT_LIST = new String[]{"/", " ", "&", ":"};

    public WikipediaTraceReader(List<String> filePaths) {
        super(filePaths);
    }

    @Override
    public LongStream events() throws IOException {
        return this.lines().map(this::parseRequest).filter(Objects::nonNull).mapToLong(path -> Hashing.murmur3_128().hashString((CharSequence)path, StandardCharsets.UTF_8).asLong());
    }

    @Nullable
    private String parseRequest(String line) {
        String path;
        if (!this.isRead(line)) {
            return null;
        }
        String url = this.getRequestUrl(line);
        if (url.length() > 12 && this.isAllowed(path = this.getPath(url))) {
            return path;
        }
        return null;
    }

    private boolean isRead(String line) {
        return line.charAt(line.length() - 1) == '-';
    }

    private String getRequestUrl(String line) {
        int end = line.length() - 2;
        while (line.charAt(end) != ' ') {
            --end;
        }
        int start = end - 1;
        while (line.charAt(start) != ' ') {
            --start;
        }
        return line.substring(start + 1, end);
    }

    private String getPath(String url) {
        String path;
        int index = url.indexOf(47, 7);
        if (index == -1) {
            return url;
        }
        String cleansed = path = url.substring(index + 1);
        for (int i = 0; i < SEARCH_LIST.length; ++i) {
            cleansed = StringUtils.replace((String)cleansed, (String)SEARCH_LIST[i], (String)REPLACEMENT_LIST[i]);
        }
        return cleansed;
    }

    public boolean isAllowed(String path) {
        for (String filter : STARTS_WITH_FILTER) {
            if (!path.startsWith(filter)) continue;
            return false;
        }
        for (String filter : CONTAINS_FILTER) {
            if (!path.contains(filter)) continue;
            return false;
        }
        return true;
    }
}

