/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import akka.actor.ActorRef;
import akka.actor.UntypedActor;
import akka.dispatch.BoundedMessageQueueSemantics;
import akka.dispatch.RequiresMessageQueue;
import com.github.benmanes.caffeine.cache.simulator.Simulator;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Objects;

public final class PolicyActor
extends UntypedActor
implements RequiresMessageQueue<BoundedMessageQueueSemantics> {
    private final Policy policy;

    public PolicyActor(Policy policy) {
        this.policy = Objects.requireNonNull(policy);
    }

    public void onReceive(Object msg) {
        if (msg instanceof LongArrayList) {
            LongArrayList events = (LongArrayList)msg;
            this.process(events);
        } else if (msg == Simulator.Message.FINISH) {
            this.policy.finished();
            this.getSender().tell((Object)this.policy.stats(), ActorRef.noSender());
            this.getContext().stop(this.getSelf());
        } else if (msg == Simulator.Message.ERROR) {
            this.getContext().stop(this.getSelf());
        } else {
            this.context().system().log().error("Invalid message: " + msg);
        }
    }

    private void process(LongArrayList events) {
        this.policy.stats().stopwatch().start();
        try {
            for (int i = 0; i < events.size(); ++i) {
                this.policy.record(events.getLong(i));
            }
        }
        catch (Exception e) {
            this.context().system().log().error((Throwable)e, "");
            this.getSender().tell((Object)Simulator.Message.ERROR, ActorRef.noSender());
        }
        finally {
            this.policy.stats().stopwatch().stop();
        }
    }
}

