/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.ArcPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.CarPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.CartPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.ClockProPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.LirsPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.FrequentlyUsedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.LinkedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.MultiQueuePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.S4LruPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.SegmentedLruPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.opt.ClairvoyantPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.opt.UnboundedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Cache2kPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.CaffeinePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Ehcache2Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Ehcache3Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.GuavaPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.InfinispanPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.TCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sampled.SamplingPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.FullySegmentedWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.S4WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.SimpleWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.TinyCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.TinyCacheWithGhostCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.WindowTinyCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.two_queue.TuQueuePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.two_queue.TwoQueuePolicy;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Registry {
    private static final Map<String, Function<Config, Set<Policy>>> FACTORIES = Registry.makeRegistry();

    private Registry() {
    }

    private static Map<String, Function<Config, Set<Policy>>> makeRegistry() {
        HashMap<String, Function<Config, Set<Policy>>> factories = new HashMap<String, Function<Config, Set<Policy>>>();
        Registry.registerIRR(factories);
        Registry.registerLinked(factories);
        Registry.registerSketch(factories);
        Registry.registerOptimal(factories);
        Registry.registerSampled(factories);
        Registry.registerProduct(factories);
        Registry.registerTwoQueue(factories);
        Registry.registerAdaptive(factories);
        return ImmutableMap.copyOf(factories);
    }

    public static Set<Policy> policies(BasicSettings settings) {
        return settings.policies().stream().map(FACTORIES::get).flatMap(factory -> ((Set)factory.apply(settings.config())).stream()).collect(Collectors.toSet());
    }

    private static void registerOptimal(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("opt.clairvoyant", ClairvoyantPolicy::policies);
        factories.put("opt.unbounded", UnboundedPolicy::policies);
    }

    private static void registerLinked(Map<String, Function<Config, Set<Policy>>> factories) {
        Stream.of(LinkedPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "linked." + priority.name().toLowerCase();
            factories.put(id, config -> LinkedPolicy.policies(config, priority));
        });
        Stream.of(FrequentlyUsedPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "linked." + priority.name().toLowerCase();
            factories.put(id, config -> FrequentlyUsedPolicy.policies(config, priority));
        });
        factories.put("linked.segmentedlru", SegmentedLruPolicy::policies);
        factories.put("linked.multiqueue", MultiQueuePolicy::policies);
        factories.put("linked.s4lru", S4LruPolicy::policies);
    }

    private static void registerSampled(Map<String, Function<Config, Set<Policy>>> factories) {
        Stream.of(SamplingPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "sampled." + priority.name().toLowerCase();
            factories.put(id, config -> SamplingPolicy.policies(config, priority));
        });
    }

    private static void registerTwoQueue(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("two-queue.tuqueue", TuQueuePolicy::policies);
        factories.put("two-queue.twoqueue", TwoQueuePolicy::policies);
    }

    private static void registerSketch(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("sketch.windowtinylfu", WindowTinyLfuPolicy::policies);
        factories.put("sketch.s4windowtinylfu", S4WindowTinyLfuPolicy::policies);
        factories.put("sketch.simplewindowtinylfu", SimpleWindowTinyLfuPolicy::policies);
        factories.put("sketch.fullysegmentedwindowtinylfu", FullySegmentedWindowTinyLfuPolicy::policies);
        factories.put("sketch.tinycache", TinyCachePolicy::policies);
        factories.put("sketch.windowtinycache", WindowTinyCachePolicy::policies);
        factories.put("sketch.tinycache_ghostcache", TinyCacheWithGhostCachePolicy::policies);
    }

    private static void registerIRR(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("irr.lirs", LirsPolicy::policies);
        factories.put("irr.clockpro", ClockProPolicy::policies);
    }

    private static void registerAdaptive(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("adaptive.arc", ArcPolicy::policies);
        factories.put("adaptive.car", CarPolicy::policies);
        factories.put("adaptive.cart", CartPolicy::policies);
    }

    private static void registerProduct(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("product.cache2k", Cache2kPolicy::policies);
        factories.put("product.guava", GuavaPolicy::policies);
        factories.put("product.ehcache2", Ehcache2Policy::policies);
        factories.put("product.ehcache3", Ehcache3Policy::policies);
        factories.put("product.caffeine", CaffeinePolicy::policies);
        factories.put("product.infinispan", InfinispanPolicy::policies);
        factories.put("product.tcache", TCachePolicy::policies);
    }
}

