/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.linked;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class FrequentlyUsedPolicy
implements Policy {
    private final PolicyStats policyStats;
    private final Long2ObjectMap<Node> data;
    private final EvictionPolicy policy;
    private final FrequencyNode freq0;
    private final Admittor admittor;
    private final int maximumSize;

    public FrequentlyUsedPolicy(Admission admission, EvictionPolicy policy, Config config) {
        String name = admission.format("linked." + policy.label());
        BasicSettings settings = new BasicSettings(config);
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        this.policyStats = new PolicyStats(name);
        this.admittor = admission.from(config);
        this.policy = Objects.requireNonNull(policy);
        this.freq0 = new FrequencyNode(0);
    }

    public static Set<Policy> policies(Config config, EvictionPolicy policy) {
        BasicSettings settings = new BasicSettings(config);
        return settings.admission().stream().map(admission -> new FrequentlyUsedPolicy((Admission)((Object)admission), policy, config)).collect(Collectors.toSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        if (node == null) {
            this.onMiss(key);
        } else {
            this.onHit(node);
        }
    }

    private void onHit(Node node) {
        this.policyStats.recordHit();
        int newCount = node.freq.count + 1;
        FrequencyNode freqN = node.freq.next.count == newCount ? node.freq.next : new FrequencyNode(newCount, node.freq);
        node.remove();
        if (node.freq.isEmpty()) {
            node.freq.remove();
        }
        node.freq = freqN;
        node.append();
    }

    private void onMiss(long key) {
        FrequencyNode freq1 = this.freq0.next.count == 1 ? this.freq0.next : new FrequencyNode(1, this.freq0);
        Node node = new Node(key, freq1);
        this.policyStats.recordMiss();
        this.data.put(key, (Object)node);
        node.append();
        this.evict(node);
    }

    private void evict(Node candidate) {
        if (this.data.size() > this.maximumSize) {
            Node victim = this.nextVictim(candidate);
            boolean admit = this.admittor.admit(candidate.key, victim.key);
            if (admit) {
                this.evictEntry(victim);
            } else {
                this.evictEntry(candidate);
            }
            this.policyStats.recordEviction();
        }
    }

    Node nextVictim(Node candidate) {
        if (this.policy == EvictionPolicy.MFU) {
            return this.freq0.prev.nextNode.next;
        }
        Node victim = this.freq0.next.nextNode.next;
        if (victim == candidate) {
            victim = victim.next == victim.prev ? victim.freq.next.nextNode.next : victim.next;
        }
        return victim;
    }

    private void evictEntry(Node node) {
        this.data.remove(node.key);
        node.remove();
        if (node.freq.isEmpty()) {
            node.freq.remove();
        }
    }

    static final class Node {
        private final long key;
        private FrequencyNode freq;
        private Node prev;
        private Node next;

        public Node(FrequencyNode freq) {
            this.key = Long.MIN_VALUE;
            this.freq = freq;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, FrequencyNode freq) {
            this.next = null;
            this.prev = null;
            this.freq = freq;
            this.key = key;
        }

        public void append() {
            this.prev = ((FrequencyNode)this.freq).nextNode.prev;
            this.next = this.freq.nextNode;
            this.prev.next = this;
            this.next.prev = this;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("freq", (Object)this.freq).toString();
        }
    }

    static final class FrequencyNode {
        private final int count;
        private final Node nextNode = new Node(this);
        private FrequencyNode prev;
        private FrequencyNode next;

        public FrequencyNode(int count) {
            this.count = count;
            this.prev = this;
            this.next = this;
        }

        public FrequencyNode(int count, FrequencyNode prev) {
            this.prev = prev;
            this.next = prev.next;
            prev.next = this;
            this.next.prev = this;
            this.count = count;
        }

        public boolean isEmpty() {
            return this.nextNode == this.nextNode.next;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).toString();
        }
    }

    public static enum EvictionPolicy {
        LFU,
        MFU;


        public String label() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }
}

