/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.opt;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.util.Set;

public final class ClairvoyantPolicy
implements Policy {
    private final Long2ObjectMap<IntPriorityQueue> accessTimes;
    private final LongArrayFIFOQueue future;
    private final PolicyStats policyStats;
    private final IntSortedSet data;
    private final int maximumSize;
    private int infiniteTimestamp;
    private int tick;

    public ClairvoyantPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.policyStats = new PolicyStats("opt.Clairvoyant");
        this.accessTimes = new Long2ObjectOpenHashMap();
        this.infiniteTimestamp = Integer.MAX_VALUE;
        this.maximumSize = settings.maximumSize();
        this.future = new LongArrayFIFOQueue();
        this.data = new IntRBTreeSet();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new ClairvoyantPolicy(config));
    }

    @Override
    public void record(long key) {
        ++this.tick;
        this.future.enqueue(key);
        IntPriorityQueue times = (IntPriorityQueue)this.accessTimes.get(key);
        if (times == null) {
            times = new IntArrayFIFOQueue();
            this.accessTimes.put(key, (Object)times);
        }
        times.enqueue(this.tick);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.policyStats.stopwatch().start();
        while (!this.future.isEmpty()) {
            this.process(this.future.dequeueLong());
        }
        this.policyStats.stopwatch().stop();
    }

    private void process(long key) {
        IntPriorityQueue times = (IntPriorityQueue)this.accessTimes.get(key);
        int lastAccess = times.dequeueInt();
        boolean found = this.data.remove(lastAccess);
        if (times.isEmpty()) {
            this.data.add(this.infiniteTimestamp--);
            this.accessTimes.remove(key);
        } else {
            this.data.add(times.firstInt());
        }
        if (found) {
            this.policyStats.recordHit();
        } else {
            this.policyStats.recordMiss();
            if (this.data.size() > this.maximumSize) {
                this.evict();
            }
        }
    }

    private void evict() {
        this.data.rem(this.data.lastInt());
        this.policyStats.recordEviction();
    }
}

