/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.typesafe.config.Config;
import java.io.PrintStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.cache2k.Cache;
import org.cache2k.CacheBuilder;
import org.cache2k.impl.ArcCache;
import org.cache2k.impl.ClockCache;
import org.cache2k.impl.ClockProPlusCache;
import org.cache2k.impl.LruCache;
import org.cache2k.impl.RandomCache;

public final class Cache2kPolicy
implements Policy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats;
    private final int maximumSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache2kPolicy(Config config) {
        Logger logger = LogManager.getLogManager().getLogger("");
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        PrintStream err = System.err;
        System.setErr(new PrintStream(ByteStreams.nullOutputStream()));
        try {
            this.policyStats = new PolicyStats("product.Cache2k");
            Cache2kSettings settings = new Cache2kSettings(config);
            this.cache = CacheBuilder.newCache(Object.class, Object.class).implementation(settings.implementation()).maxSize(settings.maximumSize()).eternal(true).build();
            this.maximumSize = settings.maximumSize();
        }
        finally {
            System.setErr(err);
            LogManager.getLogManager().getLogger("").setLevel(level);
        }
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new Cache2kPolicy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.peek((Object)key);
        if (value == null) {
            this.policyStats.recordMiss();
            if (this.cache.getTotalEntryCount() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, (Object)key);
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class Cache2kSettings
    extends BasicSettings {
        public Cache2kSettings(Config config) {
            super(config);
        }

        public Class<?> implementation() {
            String policy;
            switch (policy = this.config().getString("cache2k.policy").toLowerCase()) {
                case "arc": {
                    return ArcCache.class;
                }
                case "clock": {
                    return ClockCache.class;
                }
                case "clockpro": {
                    return ClockProPlusCache.class;
                }
                case "lru": {
                    return LruCache.class;
                }
                case "random": {
                    return RandomCache.class;
                }
            }
            throw new IllegalArgumentException("Unknown policy type: " + policy);
        }
    }
}

