/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;

public final class CaffeinePolicy
implements Policy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats("product.Caffeine");

    public CaffeinePolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.cache = Caffeine.newBuilder().executor(Runnable::run).maximumSize((long)settings.maximumSize()).initialCapacity(settings.maximumSize()).removalListener((k, v, c) -> this.policyStats.recordEviction()).build();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new CaffeinePolicy(config));
    }

    @Override
    public void record(long key) {
        boolean[] hit = new boolean[]{true};
        this.cache.get((Object)key, k -> {
            hit[0] = false;
            return k;
        });
        if (hit[0]) {
            this.policyStats.recordHit();
        } else {
            this.policyStats.recordMiss();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

