/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;

public final class Ehcache3Policy
implements Policy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats("product.Ehcache3");
    private final int maximumSize;
    private int size;

    public Ehcache3Policy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().build(true);
        this.cache = cacheManager.createCache("ehcache3", CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class).withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)settings.maximumSize(), (ResourceUnit)EntryUnit.ENTRIES).build()).build());
        this.maximumSize = settings.maximumSize();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new Ehcache3Policy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.putIfAbsent((Object)key, (Object)key);
        if (value == null) {
            ++this.size;
            this.policyStats.recordMiss();
            if (this.size > this.maximumSize) {
                this.policyStats.recordEviction();
                --this.size;
            }
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

