/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public final class GuavaPolicy
implements Policy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats("product.Guava");

    public GuavaPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)settings.maximumSize()).initialCapacity(settings.maximumSize()).removalListener(notification -> this.policyStats.recordEviction()).build();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new GuavaPolicy(config));
    }

    @Override
    public void record(long key) {
        boolean[] hit = new boolean[]{true};
        try {
            this.cache.get((Object)key, () -> {
                hit[0] = false;
                return key;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (hit[0]) {
            this.policyStats.recordHit();
        } else {
            this.policyStats.recordMiss();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

